/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildToolPlaceMessage
extends AbstractMessage<BuildToolPlaceMessage, IMessage> {
    private static final String NO_HUT_IN_INVENTORY = "com.minecolonies.coremod.gui.buildtool.nohutininventory";
    private String hutDec;
    private String style;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;
    private boolean mirror;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String hutDec, String style, BlockPos pos, int rotation, boolean isHut, Mirror mirror) {
        this.hutDec = hutDec;
        this.style = style;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
        this.mirror = mirror == Mirror.FRONT_BACK;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.hutDec = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
        this.mirror = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.hutDec);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.style);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
        buf.writeBoolean(this.mirror);
    }

    @Override
    public void messageOnServerThread(BuildToolPlaceMessage message, EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (message.isHut) {
            BuildToolPlaceMessage.handleHut(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos, message.mirror);
        } else {
            BuildToolPlaceMessage.handleDecoration(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos, message.mirror);
        }
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, String hut, String style, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        if (Structures.getStylesForHut(hut) == null) {
            Log.getLogger().error("No record of hut: " + hut);
            return;
        }
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        Colony tempColony = ColonyManager.getClosestColony(world, buildPos);
        if (!(tempColony == null || tempColony.getPermissions().hasPermission(player, Permissions.Action.MANAGE_HUTS) || block instanceof BlockHutTownHall && BlockPosUtil.getDistance2D(tempColony.getCenter(), buildPos) >= (long)(Configurations.workingRangeTownHall * 2 + Configurations.townHallPadding))) {
            return;
        }
        if (block != null && player.field_71071_by.func_70431_c(new ItemStack(block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                world.func_175655_b(buildPos, true);
                world.func_175656_a(buildPos, block.func_176223_P().func_185907_a(BlockUtils.getRotation(rotation)));
                ((AbstractBlockHut)block).onBlockPlacedByBuildTool(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null, mirror);
                player.field_71071_by.func_174925_a(Item.func_150898_a((Block)block), -1, 1, null);
                AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
                if (building == null) {
                    Log.getLogger().error("BuildTool: building is null!");
                } else {
                    if (building.getTileEntity() != null) {
                        Colony colony = ColonyManager.getColony(world, buildPos);
                        if (colony == null) {
                            Log.getLogger().info("No colony for " + player.func_70005_c_());
                        } else {
                            building.getTileEntity().setColony(colony);
                        }
                    }
                    building.setStyle(style);
                    building.setRotation(rotation);
                    if (mirror) {
                        building.setMirror();
                    }
                }
            }
        } else {
            LanguageHandler.sendPlayerMessage(player, NO_HUT_IN_INVENTORY, new Object[0]);
        }
    }

    private static void handleDecoration(@NotNull World world, @NotNull EntityPlayer player, String decoration, String style, int rotation, @NotNull BlockPos buildPos, boolean mirror) {
        if (Structures.getStylesForDecoration(decoration) == null) {
            Log.getLogger().error("No record of decoration: " + decoration);
            return;
        }
        Colony colony = ColonyManager.getColony(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildDecoration(style, decoration, rotation, buildPos, mirror));
        }
    }
}

