/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class GuardScepterMessage
extends AbstractMessage<GuardScepterMessage, IMessage> {
    private int taskId;
    private BlockPos buildingId;

    public GuardScepterMessage() {
    }

    public GuardScepterMessage(int taskId, BlockPos buildingId) {
        this.taskId = taskId;
        this.buildingId = buildingId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.taskId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.taskId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(GuardScepterMessage message, EntityPlayerMP player) {
        NBTTagCompound compound;
        ItemStack scepter = new ItemStack(ModItems.scepterGuard);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        if ((compound = scepter.func_77978_p()) == null) {
            return;
        }
        compound.func_74768_a("task", message.taskId);
        int emptySlot = player.field_71071_by.func_70447_i();
        BlockPosUtil.writeToNBT(compound, "pos", message.buildingId);
        ItemStack item = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        player.field_71071_by.func_70299_a(emptySlot, item);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, scepter);
        player.field_71071_by.func_70296_d();
    }
}

