/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static EntityPlayer getPlayerOfFakePlayer(@NotNull EntityPlayer player, @NotNull World world) {
        EntityPlayer tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.func_152378_a(player.func_110124_au())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, x, y, z, 3);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isWorkerAtSite(worker, x, y, z, 512)) {
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(worker.func_130014_f_(), new BlockPos(x, y, z), 5, 5, 5, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
            worker.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, worker.field_70177_z, worker.field_70125_A);
            return true;
        }
        if (!EntityUtils.isWorkerAtSite(worker, x, y, z, range)) {
            if (worker.getNavigator().func_75500_f() && !EntityUtils.tryMoveLivingToXYZ((EntityLiving)worker, x, y, z)) {
                worker.setStatus(EntityCitizen.Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull EntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.field_70177_z, citizen.field_70125_A);
        citizen.getNavigator().func_75499_g();
        return true;
    }

    public static boolean isWorkerAtSite(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        return worker.func_180425_c().func_177951_i(new Vec3i(x, y, z)) < MathUtils.square(range);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z, double speed) {
        return living.func_70661_as().func_75492_a((double)x, (double)y, (double)z, speed);
    }

    public static Entity getEntityFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            if (!id.equals(((Entity)world.field_72996_f.get(i)).func_110124_au())) continue;
            return (Entity)world.field_72996_f.get(i);
        }
        return null;
    }

    @NotNull
    public static List<Entity> getEntitiesFromUUID(@NotNull World world, @NotNull Collection<UUID> ids) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object o : world.field_72996_f) {
            Entity entity;
            if (!(o instanceof Entity) || !ids.contains((entity = (Entity)o).func_110124_au())) continue;
            entities.add(entity);
            if (entities.size() != ids.size()) continue;
            return entities;
        }
        return entities;
    }

    public static List<Entity> getEntitiesFromID(@NotNull World world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((World)world).func_73045_a(arg_0)).collect(Collectors.toList());
    }

    public static boolean isPathingTo(@NotNull EntityCitizen citizen, int x, int z) {
        PathPoint pathpoint = citizen.getNavigator().func_75505_d().func_75870_c();
        return pathpoint != null && pathpoint.field_75839_a == x && pathpoint.field_75838_c == z;
    }

    public static boolean checkForFreeSpace(@NotNull World world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.func_177981_b(i))) continue;
            return false;
        }
        return world.func_180495_p(groundPosition).func_185904_a().func_76220_a();
    }

    public static boolean solidOrLiquid(@NotNull World world, @NotNull BlockPos blockPos) {
        Material material = world.func_180495_p(blockPos).func_185904_a();
        return material.func_76220_a() || material.func_76224_d();
    }

    @Nullable
    public static BlockPos getSpawnPoint(World world, BlockPos nearPoint) {
        return Utils.scanForBlockNearPoint(world, nearPoint, 1, 1, 1, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
    }
}

