/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.structures.helpers.StructureProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureWrapper {
    private static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final World world;
    private final StructureProxy structure;
    private BlockPos position;
    private final String name;

    public StructureWrapper(World worldObj, String name) {
        this(worldObj, new StructureProxy(worldObj, name), name);
    }

    private StructureWrapper(World worldObj, StructureProxy structure, String name) {
        this.world = worldObj;
        this.structure = structure;
        this.name = name;
    }

    @NotNull
    private static ResourceLocation getResourceLocation(@NotNull String name) {
        return new ResourceLocation("minecolonies:schematics/" + name + ".nbt");
    }

    public static InputStream getStream(@NotNull ResourceLocation res) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Minecraft.func_71410_x().func_110442_L().func_110536_a(res).func_110527_b();
            }
            return StructureWrapper.class.getResourceAsStream(String.format("/assets/%s/%s", res.func_110624_b(), res.func_110623_a()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load stream!", e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, int rotations, @NotNull Mirror mirror) {
        try {
            StructureWrapper structureWrapper = new StructureWrapper(worldObj, name);
            structureWrapper.rotate(rotations, worldObj, pos, mirror);
            structureWrapper.placeStructure(pos);
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public void rotate(int times, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.structure.rotateWithMirror(times, world, rotatePos, mirror);
    }

    private void placeStructure(@NotNull BlockPos pos) {
        this.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.structure.getHeight(); ++j) {
            for (int k = 0; k < this.structure.getLength(); ++k) {
                for (int i = 0; i < this.structure.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.structure.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    IBlockState worldState = this.world.func_180495_p(worldPos);
                    if (localBlock == ModBlocks.blockSubstitution) continue;
                    if (localBlock == Blocks.field_150350_a && !worldState.func_185904_a().func_76220_a()) {
                        this.world.func_175698_g(worldPos);
                        continue;
                    }
                    if (localState.func_185904_a().func_76220_a()) {
                        this.placeBlock(localState, localBlock, worldPos);
                        continue;
                    }
                    delayedBlocks.add(localPos);
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.structure.getBlockState(coords);
            Block localBlock = localState.func_177230_c();
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.placeBlock(localState, localBlock, newWorldPos);
        }
    }

    private void placeBlock(IBlockState localState, @NotNull Block localBlock, @NotNull BlockPos worldPos) {
        this.world.func_180501_a(worldPos, localState, 3);
        if (this.world.func_180495_p(worldPos).func_177230_c() == localBlock) {
            if (this.world.func_180495_p(worldPos) != localState) {
                this.world.func_180501_a(worldPos, localState, 3);
            }
            localBlock.func_176213_c(this.world, worldPos, localState);
        }
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (this.doesStructureBlockEqualWorldBlock() && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(-1, 0, 0);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() + 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == this.structure.getWidth()) {
            this.progressPos.func_181079_c(0, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() + 1);
            if (this.progressPos.func_177952_p() == this.structure.getLength()) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() + 1, 0);
                if (this.progressPos.func_177956_o() == this.structure.getHeight()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean doesStructureBlockEqualWorldBlock() {
        IBlockState structureBlockState = this.structure.getBlockState(this.getLocalPosition());
        Block structureBlock = structureBlockState.func_177230_c();
        if (structureBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.func_180495_p(worldPos);
        if (structureBlock instanceof BlockDoor || structureBlock == Blocks.field_150457_bL) {
            return structureBlock == worldBlockState.func_177230_c();
        }
        if (structureBlock instanceof BlockStairs && structureBlockState == worldBlockState) {
            return true;
        }
        Template.EntityInfo entityInfo = this.structure.getEntityinfo(this.getLocalPosition());
        if (entityInfo != null) {
            return false;
        }
        return worldPos.func_177956_o() <= 0 || structureBlockState == worldBlockState;
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.func_185334_h();
    }

    public void setLocalPosition(@NotNull BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.func_177971_a((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.func_177973_b((Vec3i)this.getOffset());
    }

    public BlockPos getOffset() {
        return this.structure.getOffset();
    }

    public boolean findNextBlockToClear() {
        int count = 0;
        do {
            ++count;
            if (this.decrementBlock()) continue;
            return false;
        } while ((this.worldBlockAir() || this.doesStructureBlockEqualWorldBlock()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean findNextBlockSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesStructureBlockEqualWorldBlock() || this.isBlockNonSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockNonSolid() {
        return this.getBlock() != null && !this.getBlockState().func_185904_a().func_76220_a();
    }

    @Nullable
    public IBlockState getBlockState() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockState((BlockPos)this.progressPos);
    }

    @Nullable
    public Block getBlock() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return null;
        }
        return state.func_177230_c();
    }

    public boolean findNextBlockNonSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesStructureBlockEqualWorldBlock() || this.isBlockSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockSolid() {
        return this.getBlock() != null && this.getBlockState().func_185904_a().func_76220_a();
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(this.structure.getWidth(), this.structure.getHeight() - 1, this.structure.getLength() - 1);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == -1) {
            this.progressPos.func_181079_c(this.structure.getWidth() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() - 1);
            if (this.progressPos.func_177952_p() == -1) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() - 1, this.structure.getLength() - 1);
                if (this.progressPos.func_177956_o() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean worldBlockAir() {
        BlockPos pos = this.getBlockPosition();
        return pos.func_177956_o() <= 0 || this.world.func_175623_d(pos);
    }

    @NotNull
    public List<Template.EntityInfo> getEntities() {
        return this.structure.getTileEntities();
    }

    public BlockPos getPosition() {
        if (this.position == null) {
            return new BlockPos(0, 0, 0);
        }
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockState();
        if (block == null || blockState == null || block == Blocks.field_150350_a || blockState.func_185904_a().func_76224_d()) {
            return null;
        }
        return BlockUtils.getItemStackFromBlockState(blockState).func_77973_b();
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.structure.getHeight();
    }

    public int getWidth() {
        return this.structure.getWidth();
    }

    public int getLength() {
        return this.structure.getLength();
    }

    public StructureProxy structure() {
        return this.structure;
    }

    @Nullable
    public Template.BlockInfo getBlockInfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getBlockInfo((BlockPos)this.progressPos);
    }

    @Nullable
    public Template.EntityInfo getEntityinfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.structure.getEntityinfo((BlockPos)this.progressPos);
    }
}

