/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.compatibility.Compatibility;
import com.minecolonies.coremod.util.BlockPosUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    public static final String PICKAXE = "pickaxe";
    public static final String SHOVEL = "shovel";
    public static final String AXE = "axe";
    public static final String HOE = "hoe";
    public static final String WEAPON = "weapon";
    private static final int FORTUNE_ENCHANT_ID = 35;

    private Utils() {
    }

    @Nullable
    public static BlockPos scanForBlockNearPoint(@NotNull World world, @NotNull BlockPos point, int radiusX, int radiusY, int radiusZ, int height, Block ... blocks) {
        BlockPos closestCoords = null;
        double minDistance = Double.MAX_VALUE;
        for (int i = point.func_177958_n() - radiusX; i <= point.func_177958_n() + radiusX; ++i) {
            for (int j = point.func_177956_o() - radiusY; j <= point.func_177956_o() + radiusY; ++j) {
                for (int k = point.func_177952_p() - radiusZ; k <= point.func_177952_p() + radiusZ; ++k) {
                    if (!Utils.checkHeight(world, i, j, k, height, blocks)) continue;
                    BlockPos tempCoords = new BlockPos(i, j, k);
                    double distance = BlockPosUtil.getDistanceSquared(tempCoords, point);
                    if (closestCoords != null && !(distance < minDistance)) continue;
                    closestCoords = tempCoords;
                    minDistance = distance;
                }
            }
        }
        return closestCoords;
    }

    private static boolean checkHeight(@NotNull World world, int x, int y, int z, int height, Block ... blocks) {
        for (int dy = 0; dy < height; ++dy) {
            if (Utils.arrayContains(blocks, world.func_180495_p(new BlockPos(x, y + dy, z)).func_177230_c())) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayContains(@NotNull Object[] array, Object key) {
        for (Object o : array) {
            if (!Objects.equals(key, o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStackAxe(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b().getToolClasses(stack).contains(AXE);
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool;
    }

    public static boolean isBlockInRange(@NotNull World world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int findTopGround(@NotNull World world, int x, int z) {
        int yHolder = 1;
        while (!world.func_175710_j(new BlockPos(x, yHolder, z))) {
            ++yHolder;
        }
        while (!world.func_180495_p(new BlockPos(x, yHolder, z)).func_185914_p() || Utils.arrayContains(new Block[]{Blocks.field_150350_a, Blocks.field_150362_t, Blocks.field_150361_u}, world.func_180495_p(new BlockPos(x, yHolder, z)).func_177230_c())) {
            --yHolder;
        }
        return yHolder;
    }

    public static boolean testFlag(int data, int flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static int mask(int data, int mask) {
        return data & mask;
    }

    public static int setFlag(int data, int flag) {
        return data | flag;
    }

    public static int unsetFlag(int data, int flag) {
        return data & ~flag;
    }

    public static int toggleFlag(int data, int flag) {
        return data ^ flag;
    }

    public static boolean checkIfPickaxeQualifies(int minlevel, int level) {
        return Utils.checkIfPickaxeQualifies(minlevel, level, false);
    }

    public static boolean checkIfPickaxeQualifies(int minlevel, int level, boolean beEfficient) {
        if (minlevel < 0) {
            return true;
        }
        if (beEfficient && minlevel == 0) {
            return level >= 0 && level <= 1;
        }
        return level >= minlevel;
    }

    public static boolean isMiningTool(@Nullable ItemStack itemStack) {
        return Utils.isPickaxe(itemStack) || Utils.isShovel(itemStack);
    }

    public static boolean isShovel(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, SHOVEL);
    }

    public static boolean isHoe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, HOE);
    }

    public static boolean isTool(@Nullable ItemStack itemStack, String toolType) {
        return Utils.getMiningLevel(itemStack, toolType) >= 0 || itemStack != null && itemStack.func_77973_b() instanceof ItemHoe && HOE.equals(toolType);
    }

    public static int getMiningLevel(@Nullable ItemStack stack, @Nullable String tool) {
        if (tool == null) {
            return stack == null ? 0 : 1;
        }
        if (stack == null) {
            return -1;
        }
        if (!Compatibility.getMiningLevelCompatibility(stack, tool)) {
            return -1;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool);
    }

    public static boolean isAxe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, AXE);
    }

    public static boolean isPickaxe(@Nullable ItemStack itemStack) {
        return Utils.isTool(itemStack, PICKAXE);
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.func_77948_v()) {
            NBTTagList t = tool.func_77986_q();
            for (int i = 0; i < t.func_74745_c(); ++i) {
                short id = t.func_150305_b(i).func_74765_d("id");
                if (id != 35) continue;
                fortune = t.func_150305_b(i).func_74765_d("lvl");
            }
        }
        return fortune;
    }
}

