/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.compatibility.tinkers;

import com.minecolonies.compatibility.tinkers.SlimeTreeProxy;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;

public final class SlimeTreeCheck
extends SlimeTreeProxy {
    public static boolean isSlimeBlock(@NotNull Block block) {
        return new SlimeTreeCheck().checkForTinkersSlimeBlock(block);
    }

    public static boolean isSlimeLeaf(@NotNull Block block) {
        return new SlimeTreeCheck().checkForTinkersSlimeLeaves(block);
    }

    public static boolean isSlimeSapling(@NotNull Block block) {
        return new SlimeTreeCheck().checkForTinkersSlimeSapling(block);
    }

    public static boolean isSlimeDirtOrGrass(@NotNull Block block) {
        return new SlimeTreeCheck().checkForTinkersSlimeDirtOrGrass(block);
    }

    public static int getLeafVariant(@NotNull IBlockState leaf) {
        return new SlimeTreeCheck().getTinkersLeafVariant(leaf);
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public boolean checkForTinkersSlimeBlock(@NotNull Block block) {
        return block == TinkerCommons.blockSlimeCongealed;
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public boolean checkForTinkersSlimeLeaves(@NotNull Block block) {
        return block == TinkerWorld.slimeLeaves;
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public boolean checkForTinkersSlimeSapling(@NotNull Block block) {
        return block == TinkerWorld.slimeSapling;
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public boolean checkForTinkersSlimeDirtOrGrass(@NotNull Block block) {
        return block == TinkerWorld.slimeDirt || block == TinkerWorld.slimeGrass;
    }

    @Override
    @Optional.Method(modid="tconstruct")
    public int getTinkersLeafVariant(@NotNull IBlockState leaf) {
        return ((BlockSlimeGrass.FoliageType)leaf.func_177229_b((IProperty)BlockSlimeGrass.FOLIAGE)).getMeta();
    }
}

