/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenData {
    private static final float MAX_HEALTH = 20.0f;
    private static final int LEVEL_CAP = 5;
    private static final int LETTERS_IN_THE_ALPHABET = 26;
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static final String TAG_FEMALE = "female";
    private static final String TAG_TEXTURE = "texture";
    private static final String TAG_LEVEL = "level";
    private static final String TAG_EXPERIENCE = "experience";
    private static final String TAG_HEALTH = "health";
    private static final String TAG_MAX_HEALTH = "maxHealth";
    private static final String TAG_SKILLS = "skills";
    private static final String TAG_SKILL_STRENGTH = "strength";
    private static final String TAG_SKILL_STAMINA = "endurance";
    private static final String TAG_SKILL_SPEED = "charisma";
    private static final String TAG_SKILL_INTELLIGENCE = "intelligence";
    private static final String TAG_SKILL_DEXTERITY = "dexterity";
    private final int id;
    private String name;
    private boolean female;
    private int textureId;
    private final Colony colony;
    @Nullable
    private BuildingHome homeBuilding;
    @Nullable
    private AbstractBuildingWorker workBuilding;
    private AbstractJob job;
    private boolean dirty;
    @Nullable
    private EntityCitizen entity;
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private double health;
    private double maxHealth;
    private int level = 0;
    private double experience;

    public CitizenData(int id, Colony colony) {
        this.id = id;
        this.colony = colony;
    }

    @NotNull
    public static CitizenData createFromNBT(@NotNull NBTTagCompound compound, Colony colony) {
        int id = compound.func_74762_e(TAG_ID);
        CitizenData citizen = new CitizenData(id, colony);
        citizen.readFromNBT(compound);
        return citizen;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.name = compound.func_74779_i(TAG_NAME);
        this.female = compound.func_74767_n(TAG_FEMALE);
        this.textureId = compound.func_74762_e(TAG_TEXTURE);
        this.level = compound.func_74762_e(TAG_LEVEL);
        this.experience = compound.func_74762_e(TAG_EXPERIENCE);
        this.health = compound.func_74760_g(TAG_HEALTH);
        this.maxHealth = compound.func_74760_g(TAG_MAX_HEALTH);
        NBTTagCompound nbtTagSkillsCompound = compound.func_74775_l(TAG_SKILLS);
        this.strength = nbtTagSkillsCompound.func_74762_e(TAG_SKILL_STRENGTH);
        this.endurance = nbtTagSkillsCompound.func_74762_e(TAG_SKILL_STAMINA);
        this.charisma = nbtTagSkillsCompound.func_74762_e(TAG_SKILL_SPEED);
        this.intelligence = nbtTagSkillsCompound.func_74762_e(TAG_SKILL_INTELLIGENCE);
        this.dexterity = nbtTagSkillsCompound.func_74762_e(TAG_SKILL_DEXTERITY);
        if (compound.func_74764_b("job")) {
            this.setJob(AbstractJob.createFromNBT(this, compound.func_74775_l("job")));
        }
    }

    @Nullable
    public EntityCitizen getCitizenEntity() {
        return this.entity;
    }

    public void setCitizenEntity(EntityCitizen citizen) {
        this.entity = citizen;
        this.markDirty();
    }

    public void markDirty() {
        this.dirty = true;
        this.colony.markCitizensDirty();
    }

    @Nullable
    public static CitizenDataView createCitizenDataView(int id, ByteBuf buf) {
        CitizenDataView citizenDataView = new CitizenDataView(id);
        try {
            citizenDataView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A CitizenData.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", citizenDataView.getID()), (Throwable)ex);
            citizenDataView = null;
        }
        return citizenDataView;
    }

    public void initializeFromEntity(@NotNull EntityCitizen entity) {
        Random rand = entity.func_70681_au();
        this.entity = entity;
        this.female = rand.nextBoolean();
        this.name = this.generateName(rand);
        this.textureId = entity.field_70170_p.field_73012_v.nextInt(Integer.MAX_VALUE);
        this.health = entity.func_110143_aJ();
        this.maxHealth = entity.func_110138_aP();
        this.experience = 0.0;
        this.level = 0;
        Random random = new Random();
        this.intelligence = random.nextInt(4) + 1;
        this.charisma = random.nextInt(4) + 1;
        this.strength = random.nextInt(4) + 1;
        this.endurance = random.nextInt(4) + 1;
        this.dexterity = random.nextInt(4) + 1;
        this.markDirty();
    }

    private String generateName(@NotNull Random rand) {
        String citizenName = this.female ? String.format("%s %s. %s", CitizenData.getRandomElement(rand, Configurations.femaleFirstNames), Character.valueOf(CitizenData.getRandomLetter(rand)), CitizenData.getRandomElement(rand, Configurations.lastNames)) : String.format("%s %s. %s", CitizenData.getRandomElement(rand, Configurations.maleFirstNames), Character.valueOf(CitizenData.getRandomLetter(rand)), CitizenData.getRandomElement(rand, Configurations.lastNames));
        for (int i = 1; i <= this.getColony().getMaxCitizens(); ++i) {
            if (this.getColony().getCitizen(i) == null || !this.getColony().getCitizen(i).getName().equals(citizenName)) continue;
            citizenName = this.generateName(rand);
        }
        return citizenName;
    }

    private static String getRandomElement(@NotNull Random rand, @NotNull String[] array) {
        return array[rand.nextInt(array.length)];
    }

    private static char getRandomLetter(@NotNull Random rand) {
        return (char)(rand.nextInt(26) + 65);
    }

    public int getId() {
        return this.id;
    }

    public Colony getColony() {
        return this.colony;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFemale() {
        return this.female;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void addExperience(double xp) {
        this.experience += xp;
    }

    public void increaseLevel() {
        ++this.level;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void onRemoveBuilding(AbstractBuilding building) {
        if (this.getHomeBuilding() == building) {
            this.setHomeBuilding(null);
        }
        if (this.getWorkBuilding() == building) {
            this.setWorkBuilding(null);
        }
    }

    @Nullable
    public BuildingHome getHomeBuilding() {
        return this.homeBuilding;
    }

    public void setHomeBuilding(@Nullable BuildingHome building) {
        if (this.homeBuilding != null && building != null && this.homeBuilding != building) {
            throw new IllegalStateException("CitizenData.setHomeBuilding() - already assigned a home building when setting a new home building");
        }
        if (this.homeBuilding != building) {
            this.homeBuilding = building;
            this.markDirty();
        }
    }

    @Nullable
    public AbstractBuildingWorker getWorkBuilding() {
        return this.workBuilding;
    }

    public void setWorkBuilding(@Nullable AbstractBuildingWorker building) {
        if (this.workBuilding != null && building != null && this.workBuilding != building) {
            throw new IllegalStateException("CitizenData.setWorkBuilding() - already assigned a work building when setting a new work building");
        }
        if (this.workBuilding != building) {
            this.workBuilding = building;
            if (this.workBuilding != null) {
                if (this.job == null) {
                    this.setJob(this.workBuilding.createJob(this));
                    this.colony.getWorkManager().clearWorkForCitizen(this);
                }
            } else if (this.job != null) {
                EntityCitizen citizen = this.getCitizenEntity();
                if (citizen != null) {
                    citizen.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)citizen.field_70714_bg.field_75782_a.stream().filter((Predicate<EntityAITasks.EntityAITaskEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setWorkBuilding$16(net.minecraft.entity.ai.EntityAITasks$EntityAITaskEntry ), (Lnet/minecraft/entity/ai/EntityAITasks$EntityAITaskEntry;)Z)()).findFirst().orElse(null)).field_75733_a);
                }
                this.setJob(null);
                this.colony.getWorkManager().clearWorkForCitizen(this);
            }
            this.markDirty();
        }
    }

    public void clearCitizenEntity() {
        this.entity = null;
    }

    public AbstractJob getJob() {
        return this.job;
    }

    public void setJob(AbstractJob job) {
        this.job = job;
        EntityCitizen localEntity = this.getCitizenEntity();
        if (localEntity != null) {
            localEntity.onJobChanged(job);
        }
        this.markDirty();
    }

    @Nullable
    public <J extends AbstractJob> J getJob(@NotNull Class<J> type) {
        try {
            return (J)((AbstractJob)type.cast(this.job));
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a(TAG_ID, this.id);
        compound.func_74778_a(TAG_NAME, this.name);
        compound.func_74757_a(TAG_FEMALE, this.female);
        compound.func_74768_a(TAG_TEXTURE, this.textureId);
        compound.func_74768_a(TAG_LEVEL, this.level);
        compound.func_74780_a(TAG_EXPERIENCE, this.experience);
        compound.func_74780_a(TAG_HEALTH, this.health);
        compound.func_74780_a(TAG_MAX_HEALTH, this.maxHealth);
        NBTTagCompound nbtTagSkillsCompound = new NBTTagCompound();
        nbtTagSkillsCompound.func_74768_a(TAG_SKILL_STRENGTH, this.strength);
        nbtTagSkillsCompound.func_74768_a(TAG_SKILL_STAMINA, this.endurance);
        nbtTagSkillsCompound.func_74768_a(TAG_SKILL_SPEED, this.charisma);
        nbtTagSkillsCompound.func_74768_a(TAG_SKILL_INTELLIGENCE, this.intelligence);
        nbtTagSkillsCompound.func_74768_a(TAG_SKILL_DEXTERITY, this.dexterity);
        compound.func_74782_a(TAG_SKILLS, (NBTBase)nbtTagSkillsCompound);
        if (this.job != null) {
            NBTTagCompound jobCompound = new NBTTagCompound();
            this.job.writeToNBT(jobCompound);
            compound.func_74782_a("job", (NBTBase)jobCompound);
        }
    }

    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeBoolean(this.female);
        buf.writeInt(this.entity != null ? this.entity.func_145782_y() : -1);
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.homeBuilding.getID());
        }
        buf.writeBoolean(this.workBuilding != null);
        if (this.workBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.workBuilding.getID());
        }
        buf.writeInt(this.getLevel());
        buf.writeDouble(this.getExperience());
        if (this.entity == null) {
            buf.writeFloat(20.0f);
            buf.writeFloat(20.0f);
        } else {
            buf.writeFloat(this.entity.func_110143_aJ());
            buf.writeFloat(this.entity.func_110138_aP());
        }
        buf.writeInt(this.getStrength());
        buf.writeInt(this.getEndurance());
        buf.writeInt(this.getCharisma());
        buf.writeInt(this.getIntelligence());
        buf.writeInt(this.getDexterity());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.job != null ? this.job.getName() : ""));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public void resetExperienceAndLevel() {
        this.level = 0;
        this.experience = 0.0;
    }

    public double getExperience() {
        return this.experience;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public int getCharisma() {
        return this.charisma;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getDexterity() {
        return this.dexterity;
    }

    private static /* synthetic */ boolean lambda$setWorkBuilding$16(EntityAITasks.EntityAITaskEntry task) {
        return task.field_75733_a instanceof AbstractAISkeleton;
    }
}

