/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.BlockHutDeliveryman;
import com.minecolonies.coremod.client.gui.WindowWareHouseBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

public class BuildingWareHouse
extends AbstractBuilding {
    private static final String WAREHOUSE = "WareHouse";
    private static final String TAG_DELIVERYMAN = "Deliveryman";
    private static final List<Vec3d> registeredDeliverymen = new ArrayList<Vec3d>();
    private TileEntityWareHouse tileEntity;

    public BuildingWareHouse(Colony c, BlockPos l) {
        super(c, l);
    }

    public boolean registerWithWareHouse(BuildingDeliveryman buildingWorker) {
        if (registeredDeliverymen.contains(new Vec3d((Vec3i)buildingWorker.getID()))) {
            return true;
        }
        if (registeredDeliverymen.size() >= this.getBuildingLevel()) {
            if (!registeredDeliverymen.isEmpty()) {
                Log.getLogger().info(this.getColony().getName() + " " + Arrays.toString(registeredDeliverymen.toArray()));
                this.checkForRegisteredDeliverymen();
            }
            return false;
        }
        registeredDeliverymen.add(new Vec3d((Vec3i)buildingWorker.getID()));
        return true;
    }

    private void checkForRegisteredDeliverymen() {
        ArrayList<Vec3d> registeredDeliverymenCopy = new ArrayList<Vec3d>(registeredDeliverymen);
        for (Vec3d pos : registeredDeliverymenCopy) {
            Colony colony = this.getColony();
            if (colony == null || colony.getWorld() == null || colony.getWorld().func_180495_p(new BlockPos(pos)) instanceof BlockHutDeliveryman && !colony.isCoordInColony(colony.getWorld(), new BlockPos(pos))) continue;
            registeredDeliverymen.remove(pos);
        }
    }

    public boolean canAccessWareHouse(BuildingDeliveryman buildingWorker) {
        return registeredDeliverymen.contains(new Vec3d((Vec3i)buildingWorker.getID()));
    }

    public List<Vec3d> getRegisteredDeliverymen() {
        return Collections.unmodifiableList(registeredDeliverymen);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        registeredDeliverymen.clear();
        NBTTagList deliverymanTagList = compound.func_150295_c(TAG_DELIVERYMAN, 10);
        for (int i = 0; i < deliverymanTagList.func_74745_c(); ++i) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)deliverymanTagList.func_150305_b(i));
            if (this.getColony() == null || !(this.getColony().getBuilding(pos) instanceof AbstractBuildingWorker) || registeredDeliverymen.contains(new Vec3d((Vec3i)pos))) continue;
            registeredDeliverymen.add(new Vec3d((Vec3i)pos));
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList levelTagList = new NBTTagList();
        for (Vec3d deliverymanBuilding : registeredDeliverymen) {
            levelTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(deliverymanBuilding)));
        }
        compound.func_74782_a(TAG_DELIVERYMAN, (NBTBase)levelTagList);
    }

    @Override
    public TileEntityWareHouse getTileEntity() {
        TileEntity te;
        Colony colony = this.getColony();
        if ((this.tileEntity == null || this.tileEntity.func_145837_r()) && colony != null && colony.getWorld().func_180495_p(this.getLocation()).func_177230_c() != null && (te = this.getColony().getWorld().func_175625_s(this.getLocation())) instanceof TileEntityWareHouse) {
            this.tileEntity = (TileEntityWareHouse)te;
            if (this.tileEntity.getBuilding() == null) {
                this.tileEntity.setColony(colony);
                this.tileEntity.setBuilding(this);
            }
        }
        return this.tileEntity;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
    }

    public static class View
    extends AbstractBuildingHut.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowWareHouseBuilding(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
        }
    }
}

