/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.utils;

import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import java.io.Serializable;
import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilderResource
extends ItemStorage {
    private int amountAvailable = 0;
    private int amountPlayer = 0;

    public BuildingBuilderResource(@NotNull Item item, int damageValue, int amount) {
        super(item, damageValue, amount, false);
    }

    public BuildingBuilderResource(@NotNull Item item, int damageValue, int amount, int available) {
        this(item, damageValue, amount);
        this.amountAvailable = available;
    }

    public String getName() {
        return new ItemStack(this.getItem(), 1, this.getDamageValue()).func_82833_r();
    }

    public int getAvailable() {
        return this.amountAvailable;
    }

    public void setAvailable(int amount) {
        this.amountAvailable = amount;
    }

    public void addAvailable(int amount) {
        this.amountAvailable += amount;
    }

    public void setPlayerAmount(int amount) {
        this.amountPlayer = amount;
    }

    public int getPlayerAmount() {
        return this.amountPlayer;
    }

    public int getMissingFromPlayer() {
        return this.amountPlayer + this.amountAvailable - this.getAmount();
    }

    public RessourceAvailability getAvailabilityStatus() {
        if (this.getAmount() > this.amountAvailable) {
            if (this.amountPlayer == 0) {
                return RessourceAvailability.DONT_HAVE;
            }
            if (this.amountPlayer < this.getAmount() - this.amountAvailable) {
                return RessourceAvailability.NEED_MORE;
            }
            return RessourceAvailability.HAVE_ENOUGH;
        }
        return RessourceAvailability.NOT_NEEDED;
    }

    public String toString() {
        int itemId = Item.func_150891_b((Item)this.getItem());
        return this.getName() + "(p:" + this.amountPlayer + " a:" + this.amountAvailable + " n:" + this.getAmount() + " id=" + itemId + " damage=" + this.getDamageValue() + ") => " + this.getAvailabilityStatus().name();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            BuildingBuilderResource that = (BuildingBuilderResource)o;
            return this.getAvailable() == that.getAvailable() && this.getPlayerAmount() == that.getPlayerAmount();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + this.amountAvailable) + this.amountPlayer;
    }

    public static class ResourceComparator
    implements Comparator<BuildingBuilderResource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(BuildingBuilderResource resource1, BuildingBuilderResource resource2) {
            if (resource1.getAvailabilityStatus() == resource2.getAvailabilityStatus()) {
                return resource1.getName().compareTo(resource2.getName());
            }
            return resource2.getAvailabilityStatus().compareTo(resource1.getAvailabilityStatus());
        }
    }

    public static enum RessourceAvailability {
        NOT_NEEDED,
        DONT_HAVE,
        NEED_MORE,
        HAVE_ENOUGH;

    }
}

