/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class ChangeColonyOwnerCommand
extends AbstractSingleCommand {
    public static final String DESC = "ownerchange";
    private static final String SUCCESS_MESSAGE = "Succesfully switched Owner %s to colony %d";
    private static final String COLONY_NULL = "Couldn't find colony %d.";
    private static final String NO_ARGUMENTS = "Please define a colony and player";
    private static final String NO_PLAYER = "Can't find player to add";
    private static final String HAS_A_COLONY = "Player %s has a colony already.";

    public ChangeColonyOwnerCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        Colony colony;
        if (args.length < 2) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        if (!this.isPlayerOpped(sender, String.valueOf((Object)AbstractSingleCommand.Commands.CHANGE_COLONY_OWNER))) {
            return;
        }
        int colonyId = ChangeColonyOwnerCommand.getIthArgument(args, 0, -1);
        if (colonyId == -1) {
            String playerName = args[0];
            if (playerName == null || playerName.isEmpty()) {
                sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_PLAYER));
                return;
            }
            EntityPlayer player = sender.func_130014_f_().func_72924_a(playerName);
            IColony colony2 = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), player.func_110124_au());
            colonyId = colony2.getID();
        }
        if ((colony = ColonyManager.getColony(colonyId)) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COLONY_NULL, colonyId)));
            return;
        }
        String playerName = null;
        if (args.length >= 2) {
            playerName = args[1];
        }
        if (playerName == null || playerName.isEmpty()) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_PLAYER));
            return;
        }
        EntityPlayer player = sender.func_130014_f_().func_72924_a(playerName);
        if (player == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_PLAYER));
            return;
        }
        if (ColonyManager.getIColonyByOwner(sender.func_130014_f_(), player) != null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(String.format(HAS_A_COLONY, playerName)));
            return;
        }
        colony.getPermissions().setOwner(player);
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(SUCCESS_MESSAGE, playerName, colonyId)));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 || index == 1;
    }
}

