/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class RefreshColonyCommand
extends AbstractSingleCommand {
    public static final String DESC = "refresh";
    private static final String NO_COLONY_FOUND_MESSAGE_ID = "Colony with ID %d not found.";
    private static final String NO_COLONY_FOUND_MESSAGE = "Colony with mayor %s not found.";
    private static final String REFRESH = "Refresh succesful!";

    public RefreshColonyCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId|OwnerName>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        int colonyId = RefreshColonyCommand.getIthArgument(args, 0, -1);
        IColony tempColony = ColonyManager.getColony(colonyId);
        if (colonyId == -1 && args.length >= 1 && (player = server.func_130014_f_().func_72924_a(args[0])) != null) {
            tempColony = ColonyManager.getIColonyByOwner(server.func_130014_f_(), player);
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player2;
            UUID mayorID = sender.func_174793_f().func_110124_au();
            if (tempColony == null) {
                tempColony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), mayorID);
            }
            if (!this.canPlayerUseCommand(player2 = (EntityPlayer)sender, AbstractSingleCommand.Commands.REFRESH_COLONY, colonyId)) {
                sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
                return;
            }
        }
        if (tempColony == null) {
            if (colonyId == -1 && args.length != 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE, args[0])));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NO_COLONY_FOUND_MESSAGE_ID, colonyId)));
            }
            return;
        }
        Colony colony = ColonyManager.getColony(tempColony.getID());
        if (colony == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_COLONY_FOUND_MESSAGE_ID));
            return;
        }
        sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(REFRESH));
        colony.getPermissions().restoreOwnerIfNull();
    }

    @NotNull
    private static UUID getUUIDFromName(@NotNull ICommandSender sender, String ... args) {
        GameProfile profile;
        MinecraftServer tempServer = sender.func_130014_f_().func_73046_m();
        if (tempServer != null && (profile = tempServer.func_152358_ax().func_152655_a(args[0])) != null) {
            return profile.getId();
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0 && args.length > 0 && !args[0].isEmpty() && RefreshColonyCommand.getIthArgument(args, 0, Integer.MAX_VALUE) == Integer.MAX_VALUE;
    }
}

