/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.ai.util.ChatSpamFilter;
import com.minecolonies.coremod.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAISkeleton<J extends AbstractJob>
extends EntityAIBase {
    private static final int MUTEX_MASK = 3;
    @NotNull
    protected final J job;
    @NotNull
    protected final EntityCitizen worker;
    protected final World world;
    @NotNull
    protected final ChatSpamFilter chatSpamFilter;
    @NotNull
    private final ArrayList<AITarget> targetList = new ArrayList();
    private AIState state;

    protected AbstractAISkeleton(@NotNull J job) {
        this.func_75248_a(3);
        this.job = job;
        this.worker = ((AbstractJob)this.job).getCitizen().getCitizenEntity();
        this.world = this.worker.field_70170_p;
        this.chatSpamFilter = new ChatSpamFilter(this.worker);
        this.state = AIState.INIT;
    }

    private void registerTarget(AITarget target) {
        this.targetList.add(target);
    }

    protected final void registerTargets(AITarget ... targets) {
        Arrays.asList(targets).forEach(this::registerTarget);
    }

    public final boolean func_75250_a() {
        return this.worker.getDesiredActivity() == EntityCitizen.DesiredActivity.WORK;
    }

    public final boolean func_75253_b() {
        return super.func_75253_b();
    }

    public final void func_75249_e() {
        this.worker.setStatus(EntityCitizen.Status.WORKING);
    }

    public final void func_75251_c() {
        this.worker.setStatus(EntityCitizen.Status.IDLE);
    }

    public final void func_75246_d() {
        this.targetList.stream().anyMatch(this::checkOnTarget);
    }

    public final void func_75248_a(int mutexBits) {
        super.func_75248_a(mutexBits);
    }

    private boolean checkOnTarget(@NotNull AITarget target) {
        if (this.state != target.getState() && target.getState() != null) {
            return false;
        }
        try {
            if (!target.test()) {
                return false;
            }
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Condition check for target " + target + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        return this.applyTarget(target);
    }

    protected void onException(RuntimeException e) {
    }

    private boolean applyTarget(@NotNull AITarget target) {
        AIState newState;
        try {
            newState = target.apply();
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Action for target " + target + " threw an exception:", (Throwable)e);
            this.onException(e);
            return false;
        }
        if (newState != null) {
            this.state = newState;
            return true;
        }
        return false;
    }

    public final AIState getState() {
        return this.state;
    }

    protected int getLevelDelay() {
        return 10;
    }
}

