/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.compatibility.Compatibility;
import com.minecolonies.coremod.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree {
    private static final String TAG_LOCATION = "Location";
    private static final String TAG_LOGS = "Logs";
    private static final String TAG_STUMPS = "Stumps";
    private static final String TAG_TOP_LOG = "topLog";
    private static final int NUMBER_OF_LEAVES = 3;
    private static final int LEAVES_WIDTH = 4;
    private static final int MAX_TREE_SIZE = 256;
    private BlockPos location;
    private BlockPos topLog;
    private LinkedList<BlockPos> woodBlocks;
    private LinkedList<BlockPos> leaves;
    private boolean isTree;
    private ArrayList<BlockPos> stumpLocations;
    private int variantNumber;

    private Tree() {
        this.isTree = true;
    }

    public Tree(@NotNull World world, @NotNull BlockPos log) {
        Block block = BlockPosUtil.getBlock(world, log);
        BlockPos leaf = new BlockPos(log.func_177958_n() + 1, log.func_177956_o() + 5, log.func_177952_p());
        if (block.isWood((IBlockAccess)world, log) || Compatibility.isSlimeBlock(block)) {
            this.variantNumber = block instanceof BlockOldLog ? ((BlockPlanks.EnumType)world.func_180495_p(log).func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a() : (block instanceof BlockNewLog ? ((BlockPlanks.EnumType)world.func_180495_p(log).func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() : (Compatibility.isSlimeBlock(block) ? Compatibility.getLeafVariant(world.func_180495_p(leaf)) : 0));
            this.woodBlocks = new LinkedList();
            this.leaves = new LinkedList();
            this.location = log;
            this.topLog = log;
            this.addAndSearch(world, log);
            this.addAndSearch(world);
            this.checkTree(world, this.topLog);
            this.stumpLocations = new ArrayList();
            this.woodBlocks.clear();
        }
    }

    public static boolean checkTree(@NotNull IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.isWood(world, pos) && !Compatibility.isSlimeBlock(block)) {
            return false;
        }
        Tuple<BlockPos, BlockPos> baseAndTOp = Tree.getBottomAndTopLog(world, pos, new LinkedList<BlockPos>(), null, null);
        BlockPos basePos = (BlockPos)baseAndTOp.func_76341_a();
        return world.func_180495_p(basePos.func_177977_b()).func_185904_a().func_76220_a() && world.func_180495_p(basePos.func_177977_b()).func_177230_c() != Blocks.field_150347_e && Tree.hasEnoughLeaves(world, (BlockPos)baseAndTOp.func_76340_b());
    }

    @NotNull
    private static Tuple<BlockPos, BlockPos> getBottomAndTopLog(@NotNull IBlockAccess world, @NotNull BlockPos log, @NotNull LinkedList<BlockPos> woodenBlocks, BlockPos bottomLog, BlockPos topLog) {
        BlockPos top;
        BlockPos bottom = bottomLog == null ? log : bottomLog;
        BlockPos blockPos = top = topLog == null ? log : topLog;
        if (woodenBlocks.size() >= 256) {
            return new Tuple((Object)bottom, (Object)top);
        }
        if (log.func_177956_o() < bottom.func_177956_o()) {
            bottom = log;
        }
        if (log.func_177956_o() > top.func_177956_o()) {
            top = log;
        }
        woodenBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(temp).func_177230_c();
                    if (!block.isWood(null, temp) && !Compatibility.isSlimeBlock(block) || woodenBlocks.contains(temp)) continue;
                    return Tree.getBottomAndTopLog(world, temp, woodenBlocks, bottom, top);
                }
            }
        }
        return new Tuple((Object)bottom, (Object)top);
    }

    private static boolean hasEnoughLeaves(@NotNull IBlockAccess world, BlockPos pos) {
        int leafCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (!world.func_180495_p(pos.func_177982_a(dx, dy, dz)).func_185904_a().equals(Material.field_151584_j) || ++leafCount < 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static Tree readFromNBT(@NotNull NBTTagCompound compound) {
        Tree tree = new Tree();
        tree.location = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
        tree.woodBlocks = new LinkedList();
        NBTTagList logs = compound.func_150295_c(TAG_LOGS, 10);
        for (int i = 0; i < logs.func_74745_c(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromNBTTagList(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        NBTTagList stumps = compound.func_150295_c(TAG_STUMPS, 10);
        for (int i = 0; i < stumps.func_74745_c(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromNBTTagList(stumps, i));
        }
        tree.topLog = BlockPosUtil.readFromNBT(compound, TAG_TOP_LOG);
        return tree;
    }

    private void checkTree(@NotNull World world, @NotNull BlockPos topLog) {
        if (!world.func_180495_p(new BlockPos(this.location.func_177958_n(), this.location.func_177956_o() - 1, this.location.func_177952_p())).func_185904_a().func_76220_a()) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (!world.func_180495_p(new BlockPos(topLog.func_177958_n() + x, topLog.func_177956_o() + y, topLog.func_177952_p() + z)).func_185904_a().equals(Material.field_151584_j) || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    public void findLogs(@NotNull World world) {
        this.addAndSearch(world, this.location);
        Collections.sort(this.woodBlocks, (c1, c2) -> (int)(c1.func_177951_i((Vec3i)this.location) - c2.func_177951_i((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(this.location.func_177956_o());
        }
    }

    public void fillTreeStumps(int yLevel) {
        for (BlockPos pos : this.woodBlocks) {
            if (pos.func_177956_o() != yLevel) continue;
            this.stumpLocations.add(pos);
        }
    }

    private void addAndSearch(@NotNull World world, @NotNull BlockPos log) {
        if (this.woodBlocks.size() >= 256) {
            return;
        }
        if (log.func_177956_o() < this.location.func_177956_o()) {
            this.location = log;
        }
        if (log.func_177956_o() > this.topLog.func_177956_o()) {
            this.topLog = log;
        }
        this.woodBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.func_177982_a(x, y, z);
                    Block block = BlockPosUtil.getBlock(world, temp);
                    if (!block.isWood(null, temp) && !Compatibility.isSlimeBlock(block) || this.woodBlocks.contains(temp)) continue;
                    this.addAndSearch(world, temp);
                }
            }
        }
    }

    private void addAndSearch(@NotNull World world) {
        int temp;
        int locXMin = this.location.func_177958_n() - 4;
        int locXMax = this.location.func_177958_n() + 4;
        int locYMin = this.location.func_177956_o() + 2;
        int locZMin = this.location.func_177952_p() - 4;
        int locZMax = this.location.func_177952_p() + 4;
        if (locXMin > locXMax) {
            temp = locXMax;
            locXMax = locXMin;
            locXMin = temp;
        }
        if (locZMin > locZMax) {
            temp = locZMax;
            locZMax = locZMin;
            locZMin = temp;
        }
        for (int locX = locXMin; locX <= locXMax; ++locX) {
            for (int locY = locYMin; locY <= 256; ++locY) {
                for (int locZ = locZMin; locZ <= locZMax; ++locZ) {
                    BlockPos leaf = new BlockPos(locX, locY, locZ);
                    if (world.func_180495_p(leaf).func_185904_a() != Material.field_151584_j) continue;
                    this.leaves.add(leaf);
                }
            }
        }
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.pollLast();
    }

    public BlockPos pollNextLeaf() {
        return this.leaves.pollLast();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peekLast();
    }

    public BlockPos peekNextLeaf() {
        return this.leaves.peekLast();
    }

    public boolean hasLeaves() {
        return !this.leaves.isEmpty();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    @NotNull
    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public int getVariant() {
        return this.variantNumber;
    }

    public double squareDistance(@NotNull Tree other) {
        return this.getLocation().func_177951_i((Vec3i)other.getLocation());
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        NBTTagList logs = new NBTTagList();
        for (BlockPos log : this.woodBlocks) {
            BlockPosUtil.writeToNBTTagList(logs, log);
        }
        compound.func_74782_a(TAG_LOGS, (NBTBase)logs);
        NBTTagList stumps = new NBTTagList();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToNBTTagList(stumps, stump);
        }
        compound.func_74782_a(TAG_STUMPS, (NBTBase)stumps);
        BlockPosUtil.writeToNBT(compound, TAG_TOP_LOG, this.topLog);
    }
}

