/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Objects;
import net.minecraft.util.text.TextComponentBase;
import org.jetbrains.annotations.NotNull;

public class ChatSpamFilter {
    protected static final int BASE_TIMEOUT = 600;
    protected static final int MAX_TIMEOUT = 12000;
    private final EntityCitizen worker;
    private int speechDelay = 0;
    @NotNull
    private String speechDelayString = "";
    private int speechRepeat = 0;

    public ChatSpamFilter(EntityCitizen worker) {
        this.worker = worker;
    }

    public void requestTextComponentWithoutSpam(@NotNull TextComponentBase chat) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", chat);
    }

    public void requestTextStringWithoutSpam(@NotNull String chat) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", chat);
    }

    public String getStringOfChat(Object ... chat) {
        if (chat.length == 0) {
            return "";
        }
        StringBuilder tempString = new StringBuilder();
        for (Object object : chat) {
            if (object instanceof TextComponentBase) {
                tempString.append(((TextComponentBase)object).func_150260_c());
                continue;
            }
            tempString.append(object);
        }
        return tempString.toString();
    }

    public void talkWithoutSpam(String key, Object ... chat) {
        String curstring = key + this.getStringOfChat(chat);
        if (Objects.equals(this.speechDelayString, curstring)) {
            if (this.speechDelay > this.worker.getOffsetTicks()) {
                return;
            }
            if (600 << this.speechRepeat < 12000) {
                ++this.speechRepeat;
            }
        } else {
            this.speechRepeat = 0;
        }
        this.worker.sendLocalizedChat(key, chat);
        this.speechDelayString = key + this.getStringOfChat(chat);
        this.speechDelay = Math.min(600 << this.speechRepeat, 12000) + this.worker.getOffsetTicks();
    }
}

