/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryCitizen
implements IInventory {
    private static final int INVENTORY_SIZE = 27;
    private static final int MAX_STACK_SIZE = 64;
    private static final String TAG_INVENTORY = "Inventory";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SLOT = "Slot";
    private static final int NO_SLOT = -1;
    private static final int HOTBAR_SIZE = 0;
    @NotNull
    private ItemStack[] stacks = new ItemStack[27];
    private String customName;
    private int heldItem;
    private boolean inventoryChanged = false;
    private EntityCitizen citizen;

    public InventoryCitizen(String title, boolean localeEnabled, EntityCitizen citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public int getHotbarSize() {
        return 0;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasInventoryChanged() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public ItemStack getHeldItemMainhand() {
        return this.func_70301_a(this.heldItem);
    }

    public void setHeldItem(int slot) {
        this.heldItem = slot;
    }

    public boolean consumeInventoryItem(Item itemIn) {
        int i = this.getInventorySlotContainItem(itemIn);
        if (i < 0) {
            return false;
        }
        --this.stacks[i].field_77994_a;
        if (this.stacks[i].field_77994_a <= 0) {
            this.stacks[i] = null;
        }
        return true;
    }

    private int getInventorySlotContainItem(Item itemIn) {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null || this.stacks[i].func_77973_b() != itemIn) continue;
            return i;
        }
        return -1;
    }

    public boolean addItemStackToInventory(@Nullable ItemStack itemStackIn) {
        if (itemStackIn != null && itemStackIn.field_77994_a != 0 && itemStackIn.func_77973_b() != null) {
            try {
                int i;
                if (itemStackIn.func_77951_h()) {
                    int j = this.getFirstEmptySlot();
                    if (j == -1) {
                        return false;
                    }
                    this.stacks[j] = ItemStack.func_77944_b((ItemStack)itemStackIn);
                    itemStackIn.field_77994_a = 0;
                    return true;
                }
                do {
                    i = itemStackIn.field_77994_a;
                    itemStackIn.field_77994_a = this.storePartialItemStack(itemStackIn);
                } while (itemStackIn.field_77994_a > 0 && itemStackIn.field_77994_a < i);
                return itemStackIn.field_77994_a < i;
            }
            catch (RuntimeException exp) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exp, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemStackIn.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)itemStackIn.func_77960_j());
                try {
                    crashreportcategory.func_71507_a("Item name", (Object)itemStackIn.func_82833_r());
                }
                catch (RuntimeException e) {
                    crashreportcategory.func_71499_a("Item name", (Throwable)e);
                }
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(@NotNull ItemStack itemStackIn) {
        int i = itemStackIn.field_77994_a;
        int j = this.storeItemStack(itemStackIn);
        if (j < 0) {
            j = this.getFirstEmptySlot();
        }
        if (j < 0) {
            return i;
        }
        if (this.stacks[j] == null) {
            this.stacks[j] = itemStackIn.func_77946_l();
            this.stacks[j].field_77994_a = 0;
        }
        int k = i;
        if (i > this.stacks[j].func_77976_d() - this.stacks[j].field_77994_a) {
            k = this.stacks[j].func_77976_d() - this.stacks[j].field_77994_a;
        }
        if (k > this.func_70297_j_() - this.stacks[j].field_77994_a) {
            k = this.func_70297_j_() - this.stacks[j].field_77994_a;
        }
        if (k == 0) {
            return i;
        }
        this.stacks[j].field_77994_a += k;
        return i -= k;
    }

    private int storeItemStack(@NotNull ItemStack itemStackIn) {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null || this.stacks[i].func_77973_b() != itemStackIn.func_77973_b() || !this.stacks[i].func_77985_e() || this.stacks[i].field_77994_a >= this.stacks[i].func_77976_d() || this.stacks[i].field_77994_a >= this.func_70297_j_() || this.stacks[i].func_77981_g() && this.stacks[i].func_77960_j() != itemStackIn.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.stacks[i], (ItemStack)itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasItem(Item itemIn) {
        return this.getInventorySlotContainItem(itemIn) != -1;
    }

    public int getHeldItemSlot() {
        return this.heldItem;
    }

    public boolean isSlotEmpty(int index) {
        return this.func_70301_a(index) == null;
    }

    @NotNull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "citizen.inventory";
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c(TAG_ITEMS, 10);
        this.stacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c(TAG_SLOT) & 0x7F;
            if (j == -1 || j >= this.stacks.length) continue;
            this.stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        if (compound.func_150297_b(TAG_CUSTOM_NAME, 8)) {
            this.customName = compound.func_74779_i(TAG_CUSTOM_NAME);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.stacks[index];
                this.stacks[index] = null;
                this.func_70296_d();
                if (index == this.heldItem) {
                    if (this.citizen != null) {
                        this.citizen.removeHeldItem();
                    }
                    this.heldItem = 0;
                }
                return itemstack1;
            }
            ItemStack itemstack = this.stacks[index].func_77979_a(count);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        if (this.stacks[index] == null) {
            return null;
        }
        ItemStack itemstack = this.stacks[index];
        this.stacks[index] = null;
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (index == this.heldItem && stack == null) {
            if (this.citizen != null) {
                this.citizen.removeHeldItem();
            }
            this.heldItem = 0;
        }
        this.stacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.inventoryChanged = true;
        if (this.citizen != null) {
            this.citizen.onInventoryChanged();
        }
    }

    public boolean func_70300_a(@NotNull EntityPlayer player) {
        return this.citizen.getColony().getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = null;
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a(TAG_SLOT, (byte)i);
            this.stacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a(TAG_ITEMS, (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a(TAG_CUSTOM_NAME, this.customName);
        }
        compound.func_74782_a(TAG_INVENTORY, (NBTBase)nbttaglist);
    }
}

