/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";

    public ItemScepterGuard() {
        super("scepterGuard");
        this.func_77656_e(2);
        this.field_77777_bU = 1;
    }

    @NotNull
    public EnumActionResult func_180614_a(ItemStack scepter, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos lastPos;
        NBTTagCompound compound;
        if (worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        if ((compound = scepter.func_77978_p()).func_74764_b(TAG_LAST_POS) && (lastPos = BlockPosUtil.readFromNBT(compound, TAG_LAST_POS)).equals((Object)pos)) {
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolDoubleClick", new Object[0]);
            return EnumActionResult.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(worldIn, pos, compound, playerIn);
    }

    @NotNull
    private static EnumActionResult handleItemUsage(World worldIn, BlockPos pos, NBTTagCompound compound, EntityPlayer playerIn) {
        Colony colony = ColonyManager.getClosestColony(worldIn, pos);
        if (colony == null) {
            return EnumActionResult.FAIL;
        }
        BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
        AbstractBuilding hut = colony.getBuilding(guardTower);
        if (hut == null || !(hut instanceof BuildingGuardTower)) {
            return EnumActionResult.FAIL;
        }
        BuildingGuardTower.Task task = BuildingGuardTower.Task.values()[compound.func_74762_e("task")];
        CitizenData citizen = ((BuildingGuardTower)hut).getWorker();
        String name = "";
        if (citizen != null) {
            name = " " + citizen.getName();
        }
        if (task.equals((Object)BuildingGuardTower.Task.GUARD)) {
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickGuard", pos, name);
            ((BuildingGuardTower)hut).setGuardTarget(pos);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
        } else {
            if (!compound.func_74764_b(TAG_LAST_POS)) {
                ((BuildingGuardTower)hut).resetPatrolTargets();
            }
            ((BuildingGuardTower)hut).addPatrolTargets(pos);
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickPatrol", pos, name);
        }
        BlockPosUtil.writeToNBT(compound, TAG_LAST_POS, pos);
        return EnumActionResult.SUCCESS;
    }
}

