/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.StructureWrapper;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyCampDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_CAMP_STRUCTURE_NAME = "SupplyCamp";
    private static final int OFFSET_SOUTH_WEST = -10;
    private static final int OFFSET_SOUTH_EAST = -1;
    private static final int OFFSET_NORTH_EAST = -6;
    private static final int OFFSET_NORTH_WEST = -14;
    private static final int CHECK_X_DIRECTIONS = 4;

    public ItemSupplyCampDeployer() {
        super("supplyCampDeployer");
        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        this.func_77625_d(1);
    }

    @NotNull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn == null || playerIn == null || worldIn.field_72995_K || stack.field_77994_a == 0 || !ItemSupplyCampDeployer.isFirstPlacing(playerIn)) {
            return EnumActionResult.FAIL;
        }
        EnumFacing dir = playerIn.func_174811_aO();
        if (this.spawnCamp(worldIn, pos, dir)) {
            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)dir));
            ItemSupplyCampDeployer.fillChest((TileEntityChest)worldIn.func_175625_s(pos.func_177984_a()));
            --stack.field_77994_a;
            playerIn.func_71029_a((StatBase)ModAchievements.achievementGetSupply);
            return EnumActionResult.SUCCESS;
        }
        LanguageHandler.sendPlayerMessage(playerIn, "item.supplyCampDeployer.invalid", new Object[0]);
        return EnumActionResult.FAIL;
    }

    private static boolean isFirstPlacing(@NotNull EntityPlayer player) {
        if (Configurations.allowInfiniteSupplyChests || !player.func_189102_a(ModAchievements.achievementGetSupply)) {
            return true;
        }
        LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.error.supplyChestAlreadyPlaced", new Object[0]);
        return false;
    }

    private boolean spawnCamp(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing chestFacing) {
        if (ItemSupplyCampDeployer.isInsideAColony(world, pos)) {
            return false;
        }
        return this.checkAndPlaceSupplyCamp(world, pos, chestFacing);
    }

    private boolean checkAndPlaceSupplyCamp(World world, @NotNull BlockPos pos, @NotNull EnumFacing direction) {
        EnumFacing facing = direction;
        block5: for (int i = 0; i < 4; ++i) {
            switch (facing) {
                case NORTH: {
                    if (StructureWrapper.tryToLoadAndPlaceSupplyCampWithRotation(world, SUPPLY_CAMP_STRUCTURE_NAME, pos.func_177982_a(-6, 0, -14), 3, Mirror.NONE)) {
                        return true;
                    }
                    facing = EnumFacing.WEST;
                    continue block5;
                }
                case EAST: {
                    if (StructureWrapper.tryToLoadAndPlaceSupplyCampWithRotation(world, SUPPLY_CAMP_STRUCTURE_NAME, pos.func_177982_a(-1, 0, -6), 0, Mirror.NONE)) {
                        return true;
                    }
                    facing = EnumFacing.NORTH;
                    continue block5;
                }
                case WEST: {
                    if (StructureWrapper.tryToLoadAndPlaceSupplyCampWithRotation(world, SUPPLY_CAMP_STRUCTURE_NAME, pos.func_177982_a(-14, 0, -10), 2, Mirror.NONE)) {
                        return true;
                    }
                    facing = EnumFacing.SOUTH;
                    continue block5;
                }
                default: {
                    if (StructureWrapper.tryToLoadAndPlaceSupplyCampWithRotation(world, SUPPLY_CAMP_STRUCTURE_NAME, pos.func_177982_a(-10, 0, -1), 1, Mirror.NONE)) {
                        return true;
                    }
                    facing = EnumFacing.EAST;
                }
            }
        }
        return false;
    }

    private static void fillChest(@Nullable TileEntityChest chest) {
        if (chest == null) {
            Log.getLogger().error("Supply chest tile entity was null.");
            return;
        }
        chest.func_70299_a(0, new ItemStack(ModBlocks.blockHutTownHall));
        chest.func_70299_a(1, new ItemStack(ModItems.buildTool));
    }

    private static boolean isInsideAColony(World world, BlockPos pos) {
        return ColonyManager.isCoordinateInAnyColony(world, pos);
    }
}

