/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveWorkOrderMessage
implements IMessage,
IMessageHandler<ColonyViewRemoveWorkOrderMessage, IMessage> {
    private int colonyId;
    private int workOrderId;

    public ColonyViewRemoveWorkOrderMessage() {
    }

    public ColonyViewRemoveWorkOrderMessage(@NotNull Colony colony, int workOrderId) {
        this.colonyId = colony.getID();
        this.workOrderId = workOrderId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewRemoveWorkOrderMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewRemoveWorkOrderMessage(message.colonyId, message.workOrderId);
    }
}

