/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractMessage<HireFireMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean hire;
    private int citizenID;

    public HireFireMessage() {
    }

    public HireFireMessage(@NotNull AbstractBuilding.View building, boolean hire, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.hire = hire;
        this.citizenID = citizenID;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
    }

    @Override
    public void messageOnServerThread(HireFireMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.MANAGE_HUTS)) {
                return;
            }
            if (message.hire) {
                CitizenData citizen = colony.getCitizen(message.citizenID);
                ((AbstractBuildingWorker)colony.getBuilding(message.buildingId)).setWorker(citizen);
            } else {
                ((AbstractBuildingWorker)colony.getBuilding(message.buildingId)).setWorker(null);
            }
        }
    }
}

