/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends TileEntityColonyBuilding {
    private final CopyOnWriteArrayList<AbstractBuilding> list = new CopyOnWriteArrayList();
    private int index = 1;

    @Override
    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        AbstractBuilding wareHouseBuilding = this.getBuilding();
        if (this.getColony() != null && wareHouseBuilding instanceof BuildingWareHouse && !((BuildingWareHouse)wareHouseBuilding).getRegisteredDeliverymen().isEmpty()) {
            Map<BlockPos, AbstractBuilding> buildingMap = this.getColony().getBuildings();
            if (buildingMap.size() < this.index) {
                this.index = 1;
            }
            int i = 1;
            for (Map.Entry<BlockPos, AbstractBuilding> buildingEntry : buildingMap.entrySet()) {
                if (i == this.index) {
                    if (buildingEntry.getValue() instanceof AbstractBuildingWorker && !this.list.contains(buildingEntry.getValue()) && ((AbstractBuildingWorker)buildingEntry.getValue()).needsAnything()) {
                        this.checkInWareHouse((AbstractBuildingWorker)buildingEntry.getValue(), true);
                    }
                    ++this.index;
                }
                ++i;
            }
        }
    }

    @Nullable
    public AbstractBuilding getTask() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.remove(0);
    }

    public boolean checkInWareHouse(@NotNull AbstractBuilding buildingEntry, boolean addToList) {
        String tool;
        if (buildingEntry.areItemsNeeded()) {
            for (ItemStack stack : buildingEntry.getNeededItems()) {
                if (stack == null || this.deliveryManHasBuildingAsTask(buildingEntry) && addToList || !this.isInHut(stack)) continue;
                if (addToList) {
                    buildingEntry.setOnGoingDelivery(true);
                    this.list.add(buildingEntry);
                }
                return true;
            }
            if (this.list.contains(buildingEntry)) {
                this.list.remove(buildingEntry);
                buildingEntry.setOnGoingDelivery(false);
            }
        }
        if (!(tool = buildingEntry.getRequiredTool()).isEmpty()) {
            if (this.isToolInHut(tool, buildingEntry)) {
                if (addToList) {
                    buildingEntry.setOnGoingDelivery(true);
                    this.list.add(buildingEntry);
                }
                return true;
            }
            if (this.list.contains(buildingEntry)) {
                this.list.remove(buildingEntry);
                buildingEntry.setOnGoingDelivery(false);
            }
        }
        return false;
    }

    private boolean deliveryManHasBuildingAsTask(@NotNull AbstractBuilding buildingEntry) {
        AbstractBuilding wareHouse = this.getBuilding();
        if (wareHouse instanceof BuildingWareHouse) {
            for (Vec3d pos : ((BuildingWareHouse)wareHouse).getRegisteredDeliverymen()) {
                AbstractBuilding building;
                Colony colony = this.getColony();
                if (colony == null || !((building = colony.getBuilding(new BlockPos(pos))) instanceof BuildingDeliveryman)) continue;
                return ((BuildingDeliveryman)building).getBuildingToDeliver() != null && ((BuildingDeliveryman)building).getBuildingToDeliver().getLocation() == buildingEntry.getLocation();
            }
        }
        return false;
    }

    public boolean isInHut(@Nullable ItemStack is) {
        AbstractBuilding building = this.getBuilding();
        if (building != null) {
            if (this.isInTileEntity(building.getTileEntity(), is)) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.field_145850_b.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !this.isInTileEntity((TileEntityChest)entity, is)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockPos getPositionOfChestWithItemStack(ItemStack stack) {
        AbstractBuilding building = this.getBuilding();
        if (building != null) {
            if (this.isInTileEntity(building.getTileEntity(), stack)) {
                return building.getLocation();
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.field_145850_b.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !this.isInTileEntity((TileEntityChest)entity, stack)) continue;
                return pos;
            }
        }
        return null;
    }

    public BlockPos getPositionOfChestWithTool(@NotNull String tool, int minLevel, @NotNull AbstractBuilding requestingBuilding) {
        AbstractBuilding building = this.getBuilding();
        if (building != null) {
            if (minLevel != -1 && InventoryUtils.isPickaxeInProvider((ICapabilityProvider)building.getTileEntity(), minLevel, requestingBuilding.getBuildingLevel()) || InventoryUtils.isToolInProvider((ICapabilityProvider)building.getTileEntity(), tool, requestingBuilding.getBuildingLevel())) {
                return building.getLocation();
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.field_145850_b.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || (minLevel == -1 || !InventoryUtils.isPickaxeInProvider((ICapabilityProvider)entity, minLevel, requestingBuilding.getBuildingLevel())) && !InventoryUtils.isToolInProvider((ICapabilityProvider)((TileEntityChest)entity), tool, requestingBuilding.getBuildingLevel())) continue;
                return pos;
            }
        }
        return null;
    }

    public boolean isToolInHut(String tool, @NotNull AbstractBuilding requestingBuilding) {
        AbstractBuilding building = this.getBuilding();
        if (building != null) {
            boolean hasItem = tool.equals("pickaxe") ? InventoryUtils.isPickaxeInProvider((ICapabilityProvider)building.getTileEntity(), requestingBuilding.getNeededPickaxeLevel(), requestingBuilding.getBuildingLevel()) : InventoryUtils.isToolInProvider((ICapabilityProvider)building.getTileEntity(), tool, requestingBuilding.getBuildingLevel());
            if (hasItem) {
                return true;
            }
            for (BlockPos pos : building.getAdditionalCountainers()) {
                TileEntity entity = this.field_145850_b.func_175625_s(pos);
                if (!(entity instanceof TileEntityChest) || !(hasItem = tool.equals("pickaxe") ? InventoryUtils.isPickaxeInProvider((ICapabilityProvider)entity, requestingBuilding.getNeededPickaxeLevel(), requestingBuilding.getBuildingLevel()) : InventoryUtils.isToolInProvider((ICapabilityProvider)entity, tool, requestingBuilding.getBuildingLevel()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInTileEntity(TileEntityChest entity, ItemStack is) {
        return is != null && InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> stack != null && is.func_77969_a(stack), (xva$0, xva$1) -> InventoryFunctions.doNothing(xva$0, xva$1));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < new InvWrapper((IInventory)inventoryCitizen).getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || stack.field_77994_a == 0) continue;
            TileEntityChest chest = this.searchRightChestForStack(stack);
            if (chest == null) {
                LanguageHandler.sendPlayersMessage(this.getColony().getMessageEntityPlayers(), "com.minecolonies.coremod.wareHouse.full", new Object[0]);
                return;
            }
            InventoryUtils.addItemStackToProvider((ICapabilityProvider)chest, stack);
            new InvWrapper((IInventory)inventoryCitizen).extractItem(i, Integer.MAX_VALUE, false);
        }
    }

    @Nullable
    private TileEntityChest searchRightChestForStack(@NotNull ItemStack stack) {
        if (InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)this, stack.func_77973_b(), stack.func_77952_i()) != -1 && InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)this) != -1) {
            return this;
        }
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            TileEntity entity = this.field_145850_b.func_175625_s(pos);
            if (!(entity instanceof TileEntityChest) || InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)entity, stack.func_77973_b(), stack.func_77952_i()) == -1 || InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)entity) == -1) continue;
            return (TileEntityChest)entity;
        }
        TileEntityChest chest = this.searchChestWithSimilarItem(stack);
        return chest == null ? this.searchMostEmptySlot() : chest;
    }

    @Nullable
    private TileEntityChest searchChestWithSimilarItem(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            TileEntity entity = this.field_145850_b.func_175625_s(pos);
            if (!(entity instanceof TileEntityChest) || InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)entity, stack.func_77973_b(), -1) == -1 || InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)entity) == -1) continue;
            return (TileEntityChest)entity;
        }
        return null;
    }

    @Nullable
    private TileEntityChest searchMostEmptySlot() {
        int freeSlots = 0;
        TileEntityChest emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getAdditionalCountainers()) {
            int tempFreeSlots;
            TileEntity entity = this.field_145850_b.func_175625_s(pos);
            if (entity == null) {
                this.getBuilding().removeContainerPosition(pos);
                continue;
            }
            if (!(entity instanceof TileEntityChest) || InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)entity) == -1 || freeSlots >= (tempFreeSlots = ((TileEntityChest)entity).func_70302_i_() - InventoryUtils.getAmountOfStacksInProvider((ICapabilityProvider)entity))) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = (TileEntityChest)entity;
        }
        return emptiestChest;
    }
}

