/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    public static final int FREE_TOOL_CHOICE_LEVEL = 4;
    public static final int EFFECT_TOOL_CHOICE_LEVEL = 2;
    public static final ItemStack EMPTY = null;

    private InventoryUtils() {
    }

    @NotNull
    public static List<ItemStack> getItemHandlerAsList(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> true);
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int metaData) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (InventoryUtils.isItemStackEmpty(stack).booleanValue() || !itemStackSelectionPredicate.test(stack)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemStackSelectionPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.filterItemHandler(itemHandler, itemStackSelectionPredicate).stream().mapToInt(InventoryUtils::getItemStackSize).sum();
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, itemStackSelectionPredicate) > 0;
    }

    public static int getFirstOpenSlotFromItemHandler(@NotNull IItemHandler itemHandler) {
        return IntStream.range(0, itemHandler.getSlots()).filter(slot -> InventoryUtils.isItemStackEmpty(itemHandler.insertItem(slot, new ItemStack(Blocks.field_150357_h), true))).filter(slot -> InventoryUtils.isItemStackEmpty(itemHandler.insertItem(slot, new ItemStack(Items.field_151042_j), true))).findFirst().orElse(-1);
    }

    public static boolean isItemHandlerFull(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler) == -1;
    }

    public static boolean isToolInItemHandler(@NotNull IItemHandler itemHandler, @NotNull String toolTypeName, int minimalLevel) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> Utils.isTool(stack, toolTypeName) && InventoryUtils.hasToolLevel(stack, toolTypeName, minimalLevel));
    }

    public static boolean isPickaxeInItemHandler(IItemHandler itemHandler, int requiredLevel) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> Utils.checkIfPickaxeQualifies(requiredLevel, Utils.getMiningLevel(stack, "pickaxe")));
    }

    public static boolean isPickaxeInItemHandler(IItemHandler itemHandler, int requiredLevel, int maximalLevel) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> Utils.checkIfPickaxeQualifies(requiredLevel, Utils.getMiningLevel(stack, "pickaxe")) && InventoryUtils.hasToolLevel(stack, "pickaxe", maximalLevel));
    }

    public static boolean addItemStackToItemHandler(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (!InventoryUtils.isItemStackEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack, false);
                    return true;
                }
                return false;
            }
            ItemStack resultStack = itemStack;
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!InventoryUtils.isItemStackEmpty(resultStack).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (InventoryUtils.isItemStackEmpty(resultStack = itemHandler.insertItem(slot, resultStack, false)).booleanValue()) continue;
                ++slot;
            }
            return InventoryUtils.isItemStackEmpty(resultStack);
        }
        return false;
    }

    public static ItemStack addItemStackToItemHandlerWithResult(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (!InventoryUtils.isItemStackEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack, false);
                    return EMPTY;
                }
                return itemStack;
            }
            ItemStack resultStack = itemStack;
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!InventoryUtils.isItemStackEmpty(resultStack).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (InventoryUtils.isItemStackEmpty(resultStack = itemHandler.insertItem(slot, resultStack, false)).booleanValue()) continue;
                ++slot;
            }
            return resultStack;
        }
        return itemStack;
    }

    @Nullable
    public static ItemStack forceItemStackToItemHandler(@NotNull IItemHandler itemHandler, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        if (!InventoryUtils.addItemStackToItemHandler(itemHandler, itemStack)) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack localStack = itemHandler.getStackInSlot(i);
                if (!InventoryUtils.isItemStackEmpty(localStack).booleanValue() && itemStackToKeepPredicate.test(localStack)) continue;
                ItemStack removedStack = itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                if (!InventoryUtils.isItemStackEmpty(itemHandler.insertItem(i, itemStack, true)).booleanValue()) continue;
                itemHandler.insertItem(i, itemStack, false);
                return removedStack.func_77946_l();
            }
        }
        return EMPTY;
    }

    public static int getAmountOfStacksInItemHandler(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.getItemHandlerAsList(itemHandler).size();
    }

    @NotNull
    public static List<ItemStack> getProviderAsList(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.filterProvider(provider, stack -> true);
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, Block block, int metaData) {
        return InventoryUtils.filterProvider(provider, stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @Nullable Item targetItem, int itemDamage) {
        return InventoryUtils.filterProvider(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getFromProviderForAllSides(provider, itemStackSelectionPredicate);
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderWith(provider, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderWith(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Predicate<ItemStack> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findFirstSlotInItemHandlerWith(handler, itemStackSelectionPredicate);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInProvider(provider, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInProvider(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().mapToInt(handler -> InventoryUtils.filterItemHandler(handler, itemStackSelectionPredicate).stream().mapToInt(InventoryUtils::getItemStackSize).sum()).sum();
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInProvider(Provider, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInProvider(Provider, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemCountInProvider(Provider, itemStackSelectionPredicate) > 0;
    }

    public static int getFirstOpenSlotFromProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().mapToInt(InventoryUtils::getFirstOpenSlotFromItemHandler).filter(slotIndex -> slotIndex > -1).findFirst().orElse(-1);
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getFirstOpenSlotFromProvider(provider) == -1;
    }

    public static boolean isToolInProvider(@NotNull ICapabilityProvider provider, @NotNull String toolTypeName, int minimalLevel) {
        return InventoryUtils.hasItemInProvider(provider, stack -> Utils.isTool(stack, toolTypeName) && InventoryUtils.hasToolLevel(stack, toolTypeName, minimalLevel));
    }

    public static boolean isPickaxeInProvider(ICapabilityProvider provider, int requiredLevel) {
        return InventoryUtils.hasItemInProvider(provider, stack -> Utils.checkIfPickaxeQualifies(requiredLevel, Utils.getMiningLevel(stack, "pickaxe")));
    }

    public static boolean isPickaxeInProvider(ICapabilityProvider provider, int requiredLevel, int maximalLevel) {
        return InventoryUtils.hasItemInProvider(provider, stack -> Utils.checkIfPickaxeQualifies(requiredLevel, Utils.getMiningLevel(stack, "pickaxe")) && InventoryUtils.hasToolLevel(stack, "pickaxe", maximalLevel));
    }

    public static boolean addItemStackToProvider(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().anyMatch(handler -> InventoryUtils.addItemStackToItemHandler(handler, itemStack));
    }

    public static ItemStack addItemStackToProviderWithResult(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        ItemStack activeStack = itemStack;
        if (InventoryUtils.isItemStackEmpty(activeStack).booleanValue()) {
            return EMPTY;
        }
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            activeStack = InventoryUtils.addItemStackToItemHandlerWithResult(handler, activeStack);
        }
        return activeStack;
    }

    @Nullable
    public static ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        if (!InventoryUtils.addItemStackToProvider(provider, itemStack)) {
            return InventoryUtils.getItemHandlersFromProvider(provider).stream().map(handler -> InventoryUtils.forceItemStackToItemHandler(handler, itemStack, itemStackToKeepPredicate)).filter(Objects::nonNull).findFirst().orElse(EMPTY);
        }
        return EMPTY;
    }

    public static int getAmountOfStacksInProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getProviderAsList(provider).size();
    }

    @NotNull
    private static List<ItemStack> getFromProviderForAllSides(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> combinedList = new ArrayList<ItemStack>();
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            combinedList.addAll(InventoryUtils.filterItemHandler(handler, predicate));
        }
        return combinedList;
    }

    @NotNull
    public static List<IItemHandler> getItemHandlersFromProvider(@NotNull ICapabilityProvider provider) {
        IItemHandler nullHandler;
        ArrayList handlerList = Arrays.stream(EnumFacing.field_82609_l).filter(facing -> provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)).map(facing -> (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)).distinct().collect(Collectors.toCollection(ArrayList::new));
        if (provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && !handlerList.contains(nullHandler = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) {
            handlerList.add(nullHandler);
        }
        return handlerList;
    }

    @NotNull
    public static boolean hasProviderIItemHandler(@NotNull ICapabilityProvider provider) {
        return !InventoryUtils.getItemHandlersFromProvider(provider).isEmpty();
    }

    @NotNull
    public static boolean isProviderSided(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).size() > 1;
    }

    @NotNull
    public static List<ItemStack> getInventoryAsListFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> true);
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int metaData) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return Collections.EMPTY_LIST;
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate);
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return -1;
        }
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate);
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return 0;
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate).stream().mapToInt(InventoryUtils::getItemStackSize).sum();
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate) > 0;
    }

    public static int getFirstOpenSlotFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return -1;
        }
        return InventoryUtils.getFirstOpenSlotFromItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        return InventoryUtils.getFirstOpenSlotFromProviderForSide(provider, facing) == -1;
    }

    public static boolean isToolInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull String toolTypeName, int minimalLevel) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        return InventoryUtils.isToolInItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), toolTypeName, minimalLevel);
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem, int itemDamage) {
        return InventoryUtils.isItemStackEmpty(itemStack) == false && itemStack.func_77973_b() == targetItem && (itemStack.func_77952_i() == itemDamage || itemDamage == -1);
    }

    public static Item getItemFromBlock(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static boolean hasToolLevel(@Nullable ItemStack stack, String toolName, int minimalLevel) {
        if (InventoryUtils.isItemStackEmpty(stack).booleanValue()) {
            return false;
        }
        int level = Utils.getMiningLevel(stack, toolName);
        return Utils.isTool(stack, toolName) && InventoryUtils.verifyToolLevel(stack, level, minimalLevel);
    }

    public static boolean verifyToolLevel(@NotNull ItemStack itemStack, int toolLevel, int minimalLevel) {
        if (InventoryUtils.isItemStackEmpty(itemStack).booleanValue() || minimalLevel > 4 || minimalLevel >= toolLevel) {
            return true;
        }
        if (itemStack.func_77948_v() && minimalLevel <= 2) {
            return false;
        }
        return false;
    }

    public static void clearItemHandler(@NotNull IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            itemHandler.extractItem(slotIndex, Integer.MAX_VALUE, false);
        }
    }

    public static int getFirstSlotOfItemHandlerContainingTool(@NotNull IItemHandler itemHandler, @NotNull String tool) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> InventoryUtils.isItemStackEmpty(stack) == false && (stack.func_77973_b().getToolClasses(stack).contains(tool) || "hoe".equals(tool) && stack.func_77977_a().contains("hoe") || "rod".equals(tool) && stack.func_77977_a().contains("fishingRod")));
    }

    public static boolean hasItemHandlerToolWithLevel(@NotNull IItemHandler itemHandler, String toolTypeName, int requiredLevel) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> InventoryUtils.isItemStackEmpty(stack) == false && Utils.isTool(stack, toolTypeName) && InventoryUtils.verifyToolLevel(stack, Utils.getMiningLevel(stack, toolTypeName), requiredLevel)) > -1;
    }

    public static boolean transferItemStackIntoNextFreeSlotInItemHandlers(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        ItemStack originalStack = sourceStack.func_77946_l();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (!InventoryUtils.isItemStackEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            return true;
        }
        if (!ItemStack.func_77989_b((ItemStack)sourceStack, (ItemStack)originalStack) && InventoryUtils.compareItemStacksIgnoreStackSize(sourceStack, originalStack).booleanValue()) {
            int usedAmount = originalStack.field_77994_a - originalStack.field_77994_a;
            sourceHandler.extractItem(sourceIndex, usedAmount, false);
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextFreeSlotInProvider(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull ICapabilityProvider targetProvider) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(targetProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers(sourceHandler, sourceIndex, handler)) continue;
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextFreeSlotFromProvider(@NotNull ICapabilityProvider sourceProvider, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers(handler, sourceIndex, targetHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean swapItemStacksInItemHandlers(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler, @NotNull int targetIndex) {
        ItemStack targetStack = targetHandler.extractItem(targetIndex, Integer.MAX_VALUE, false);
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        ItemStack resultSourceSimulationInsertion = targetHandler.insertItem(targetIndex, sourceStack, true);
        if (InventoryUtils.isItemStackEmpty(resultSourceSimulationInsertion).booleanValue() || InventoryUtils.isItemStackEmpty(targetStack).booleanValue()) {
            targetHandler.insertItem(targetIndex, sourceStack, false);
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            sourceHandler.insertItem(sourceIndex, targetStack, false);
            return true;
        }
        targetHandler.insertItem(targetIndex, targetStack, false);
        return false;
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    private static ItemStack storePartialItemStack(@NotNull IItemHandler itemHandler, @NotNull ItemStack itemStack) {
        if (!InventoryUtils.isItemStackEmpty(itemStack = itemStack.func_77946_l()).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    return itemHandler.insertItem(slot2, itemStack, false);
                }
                return EMPTY;
            }
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!InventoryUtils.isItemStackEmpty(itemStack).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (InventoryUtils.isItemStackEmpty(itemStack = itemHandler.insertItem(slot, itemStack, false)).booleanValue()) continue;
                ++slot;
            }
            return itemStack;
        }
        return EMPTY;
    }

    @NotNull
    public static int getItemStackSize(ItemStack stack) {
        if (InventoryUtils.isItemStackEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.field_77994_a;
    }

    @NotNull
    public static Boolean isItemStackEmpty(@Nullable ItemStack stack) {
        return stack == EMPTY || stack.func_77973_b() == null || stack.field_77994_a <= 0;
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        if (!InventoryUtils.isItemStackEmpty(itemStack1).booleanValue() && !InventoryUtils.isItemStackEmpty(itemStack2).booleanValue() && itemStack1.func_77973_b() == itemStack2.func_77973_b() && itemStack1.func_77952_i() == itemStack2.func_77952_i()) {
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                if (ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!InventoryUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.func_77976_d() >= InventoryUtils.getItemStackSize(existingStack) + InventoryUtils.getItemStackSize(mergingStack);
    }
}

