/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.sounds.CitizenSounds;
import com.minecolonies.coremod.sounds.FishermanSounds;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final int ONE_HUNDRED = 100;
    private static final double PITCH = 0.9;
    private static final Random rand = new Random();
    private static final double VOLUME = 0.5;
    private static final int CHANCE_TO_PLAY_SOUND = 2400;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull World worldIn, @NotNull EntityCitizen citizen) {
        if (1 >= rand.nextInt(2400)) {
            String prefix = "";
            if (citizen.getWorkBuilding() != null) {
                prefix = citizen.getWorkBuilding().getJobName();
            }
            switch (prefix) {
                case "Fisherman": {
                    FishermanSounds.playFishermanSound(worldIn, citizen.func_180425_c(), citizen.isFemale());
                    break;
                }
                default: {
                    CitizenSounds.playCitizenSounds(worldIn, citizen.func_180425_c(), citizen.isFemale());
                }
            }
        }
    }

    public static void playSoundAtCitizen(@NotNull World worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.func_184133_a((EntityPlayer)null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSoundAtCitizenWithChance(@NotNull World worldIn, @NotNull BlockPos position, @Nullable SoundEvent event, int chance) {
        if (event == null) {
            return;
        }
        if (chance > rand.nextInt(100)) {
            worldIn.func_184133_a((EntityPlayer)null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }
}

