/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.commands.MinecoloniesCommand;
import com.minecolonies.coremod.configuration.Configurations;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public final class TeleportToColony {
    private static final String CANT_FIND_COLONY = "No Colony found for teleport, please define one.";
    private static final String CANT_FIND_PLAYER = "No player found for teleport, please define one.";
    private static final String NO_TOWNHALL = "Target colony has no town hall, can't teleport.";

    private TeleportToColony() {
    }

    @NotNull
    public static void colonyTeleport(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) {
        int colonyId;
        EntityPlayer playerToTeleport;
        if (sender instanceof EntityPlayer) {
            if (args.length == 0) {
                playerToTeleport = (EntityPlayer)sender;
                IColony colony = ColonyManager.getIColonyByOwner(((EntityPlayer)sender).field_70170_p, (EntityPlayer)sender);
                colonyId = colony.getID();
            } else {
                playerToTeleport = (EntityPlayer)sender;
                colonyId = Integer.valueOf(args[0]);
            }
        } else {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_PLAYER));
            return;
        }
        if (MinecoloniesCommand.canExecuteCommand((EntityPlayer)sender)) {
            TeleportToColony.teleportPlayer(playerToTeleport, colonyId, sender);
            return;
        }
        sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("Please wait at least " + Configurations.teleportBuffer + " seconds to teleport again"));
    }

    private static void teleportPlayer(EntityPlayer playerToTeleport, int colID, ICommandSender sender) {
        Colony colony = ColonyManager.getColony(colID);
        BuildingTownHall townHall = colony.getTownHall();
        if (townHall == null) {
            sender.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(NO_TOWNHALL));
            return;
        }
        playerToTeleport.func_174793_f().func_145747_a((ITextComponent)new TextComponentString("We got places to go, kid..."));
        BlockPos position = townHall.getLocation();
        if (colID >= 1) {
            playerToTeleport.func_70634_a((double)position.func_177958_n(), (double)position.func_177956_o() + 2.0, (double)position.func_177952_p());
        } else {
            playerToTeleport.func_174793_f().func_145747_a((ITextComponent)new TextComponentString(CANT_FIND_COLONY));
        }
    }
}

