/*
 * Decompiled with CFR 0.152.
 */
package com.blockout;

import com.blockout.Color;
import com.blockout.View;
import com.minecolonies.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public class PaneParams {
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("([-+]?\\d+)(%|px)?", 2);
    private static final Pattern RGBA_PATTERN = Pattern.compile("rgba?\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*(?:,\\s*([01]\\.\\d+)\\s*)?\\)", 2);
    private Node node;
    private View parentView;

    public PaneParams(Node n) {
        this.node = n;
    }

    public String getType() {
        return this.node.getNodeName();
    }

    public View getParentView() {
        return this.parentView;
    }

    public void setParentView(View parent) {
        this.parentView = parent;
    }

    public int getParentWidth() {
        return this.parentView != null ? this.parentView.getInteriorWidth() : 0;
    }

    public int getParentHeight() {
        return this.parentView != null ? this.parentView.getInteriorHeight() : 0;
    }

    @Nullable
    public List<PaneParams> getChildren() {
        ArrayList<PaneParams> list = null;
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (list == null) {
                list = new ArrayList<PaneParams>();
            }
            list.add(new PaneParams(child));
        }
        return list;
    }

    @NotNull
    public String getText() {
        return this.node.getTextContent().trim();
    }

    @Nullable
    public String getLocalizedText() {
        return PaneParams.localize(this.node.getTextContent().trim());
    }

    @Nullable
    private static String localize(String str) {
        int endIndex;
        if (str == null) {
            return null;
        }
        String s = str;
        int index = s.indexOf("$(");
        while (index != -1 && (endIndex = s.indexOf(41, index)) != -1) {
            String key = s.substring(index + 2, endIndex);
            String replacement = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            if (replacement.equals(key)) {
                replacement = "MISSING:" + key;
            }
            s = s.substring(0, index) + replacement + s.substring(endIndex + 1);
            index = s.indexOf("$(", index + replacement.length());
        }
        return s;
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, "");
    }

    public String getStringAttribute(String name, String def) {
        Node attr = this.getAttribute(name);
        return attr != null ? attr.getNodeValue() : def;
    }

    private Node getAttribute(String name) {
        return this.node.getAttributes().getNamedItem(name);
    }

    @Nullable
    public String getLocalizedStringAttribute(String name) {
        return this.getLocalizedStringAttribute(name, "");
    }

    @Nullable
    public String getLocalizedStringAttribute(String name, String def) {
        return PaneParams.localize(this.getStringAttribute(name, def));
    }

    public int getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, 0);
    }

    public int getIntegerAttribute(String name, int def) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            return Integer.parseInt(attr);
        }
        return def;
    }

    public float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, 0.0f);
    }

    public float getFloatAttribute(String name, float def) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            return Float.parseFloat(attr);
        }
        return def;
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double def) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            return Double.parseDouble(attr);
        }
        return def;
    }

    public boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, false);
    }

    public boolean getBooleanAttribute(String name, boolean def) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            return Boolean.parseBoolean(attr);
        }
        return def;
    }

    public <T extends Enum<T>> T getEnumAttribute(String name, Class<T> clazz, T def) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            return Enum.valueOf(clazz, attr);
        }
        return def;
    }

    public int getScalableIntegerAttribute(String name, int def, int scale) {
        Matcher m;
        String attr = this.getStringAttribute(name, null);
        if (attr != null && (m = PERCENTAGE_PATTERN.matcher(attr)).find()) {
            return PaneParams.parseScalableIntegerRegexMatch(m, def, scale);
        }
        return def;
    }

    private static int parseScalableIntegerRegexMatch(Matcher m, int def, int scale) {
        try {
            int value = Integer.parseInt(m.group(1));
            if ("%".equals(m.group(2))) {
                value = scale * MathHelper.func_76125_a((int)value, (int)0, (int)100) / 100;
            }
            return value;
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NumberFormatException ex) {
            Log.logger.warn((Object)ex);
            return def;
        }
    }

    @Nullable
    public SizePair getSizePairAttribute(String name, SizePair def, SizePair scale) {
        String attr = this.getStringAttribute(name, null);
        if (attr != null) {
            int w = def != null ? def.x : 0;
            int h = def != null ? def.y : 0;
            Matcher m = PERCENTAGE_PATTERN.matcher(attr);
            if (m.find()) {
                w = PaneParams.parseScalableIntegerRegexMatch(m, w, scale != null ? scale.x : 0);
                if (m.find() || m.find(0)) {
                    h = PaneParams.parseScalableIntegerRegexMatch(m, h, scale != null ? scale.y : 0);
                }
            }
            return new SizePair(w, h);
        }
        return def;
    }

    public int getColorAttribute(String name, int def) {
        String attr = this.getStringAttribute(name, null);
        if (attr == null) {
            return def;
        }
        Matcher m = RGBA_PATTERN.matcher(attr);
        if (attr.startsWith("#")) {
            return Integer.parseInt(attr.substring(1), 16);
        }
        if ((attr.startsWith("rgb(") || attr.startsWith("rgba(")) && m.find()) {
            return PaneParams.getRGBA(attr, m);
        }
        return PaneParams.getColorByNumberOrName(def, attr);
    }

    private static int getRGBA(String attr, Matcher m) {
        int r = MathHelper.func_76125_a((int)Integer.parseInt(m.group(1)), (int)0, (int)255);
        int g = MathHelper.func_76125_a((int)Integer.parseInt(m.group(2)), (int)0, (int)255);
        int b = MathHelper.func_76125_a((int)Integer.parseInt(m.group(3)), (int)0, (int)255);
        int color = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        if (attr.startsWith("rgba")) {
            int alpha = (int)(Double.parseDouble(m.group(4)) * 255.0);
            color |= MathHelper.func_76125_a((int)alpha, (int)0, (int)255) << 24;
        }
        return color;
    }

    private static int getColorByNumberOrName(int def, String attr) {
        try {
            return Integer.parseInt(attr);
        }
        catch (NumberFormatException ex) {
            return Color.getByName(attr, def);
        }
    }

    public static class SizePair {
        private int x;
        private int y;

        public SizePair(int w, int h) {
            this.x = w;
            this.y = h;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

