/*
 * Decompiled with CFR 0.152.
 */
package com.blockout.controls;

import com.blockout.Pane;
import com.blockout.PaneParams;
import com.blockout.View;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends Pane {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    protected int maxTextLength = 32;
    protected int textColor = 0xE0E0E0;
    protected int textColorDisabled = 0x707070;
    protected boolean shadow = true;
    @Nullable
    protected String tabNextPaneID = null;
    protected String text = "";
    protected Filter filter;
    protected int cursorPosition = 0;
    protected int scrollOffset = 0;
    protected int selectionEnd = 0;
    protected int cursorBlinkCounter = 0;

    public TextField() {
    }

    public TextField(@NotNull PaneParams params) {
        super(params);
        this.maxTextLength = params.getIntegerAttribute("maxlength", this.maxTextLength);
        this.textColor = params.getColorAttribute("color", this.textColor);
        this.textColorDisabled = params.getColorAttribute("colordisabled", this.textColorDisabled);
        this.shadow = params.getBooleanAttribute("shadow", this.shadow);
        this.text = params.getLocalizedStringAttribute("textContent", this.text);
        this.tabNextPaneID = params.getStringAttribute("tab", null);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public String getText() {
        return this.text;
    }

    public void setText(@NotNull String s) {
        this.text = s.length() <= this.maxTextLength ? s : s.substring(0, this.maxTextLength);
        this.setCursorPosition(this.text.length());
    }

    public int getInternalWidth() {
        return this.getWidth();
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int m) {
        this.maxTextLength = m;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int c) {
        this.textColor = c;
    }

    public int getTextColorDisabled() {
        return this.textColorDisabled;
    }

    public void setTextColorDisabled(int c) {
        this.textColorDisabled = c;
    }

    @Nullable
    public String getTabNextPaneID() {
        return this.tabNextPaneID;
    }

    public void setTabNextPaneID(String nextID) {
        this.tabNextPaneID = nextID;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
        this.setSelectionEnd(this.cursorPosition);
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selectionEnd + offset);
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int pos) {
        this.selectionEnd = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
        int internalWidth = this.getInternalWidth();
        if (internalWidth > 0) {
            if (this.scrollOffset > this.text.length()) {
                this.scrollOffset = this.text.length();
            }
            String visibleString = this.mc.field_71466_p.func_78269_a(this.text.substring(this.scrollOffset), internalWidth);
            int rightmostVisibleChar = visibleString.length() + this.scrollOffset;
            if (this.selectionEnd == this.scrollOffset) {
                this.scrollOffset -= this.mc.field_71466_p.func_78262_a(this.text, internalWidth, true).length();
            }
            if (this.selectionEnd > rightmostVisibleChar) {
                this.scrollOffset += this.selectionEnd - rightmostVisibleChar;
            } else if (this.selectionEnd <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - this.selectionEnd;
            }
            this.scrollOffset = MathHelper.func_76125_a((int)this.scrollOffset, (int)0, (int)this.text.length());
        }
    }

    @NotNull
    public String getSelectedText() {
        int start = Math.min(this.cursorPosition, this.selectionEnd);
        int end = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(start, end);
    }

    private boolean handleKey(char c, int key) {
        switch (key) {
            case 14: 
            case 211: {
                return this.handleDelete(key);
            }
            case 199: 
            case 207: {
                return this.handleHomeEnd(key);
            }
            case 203: 
            case 205: {
                return this.handleArrowKeys(key);
            }
            case 15: {
                return this.handleTab();
            }
        }
        return this.handleChar(c);
    }

    private boolean handleChar(char c) {
        if (this.filter.isAllowedCharacter(c)) {
            this.writeText(Character.toString(c));
            return true;
        }
        return false;
    }

    private boolean handleTab() {
        Pane next;
        if (this.tabNextPaneID != null && (next = this.getWindow().findPaneByID(this.tabNextPaneID)) != null) {
            next.setFocus();
        }
        return true;
    }

    private boolean handleArrowKeys(int key) {
        int direction;
        int n = direction = key == 203 ? -1 : 1;
        if (GuiScreen.func_146272_n()) {
            if (GuiScreen.func_146271_m()) {
                this.setSelectionEnd(this.getNthWordFromPos(direction, this.getSelectionEnd()));
            } else {
                this.setSelectionEnd(this.getSelectionEnd() + direction);
            }
        } else if (GuiScreen.func_146271_m()) {
            this.setCursorPosition(this.getNthWordFromCursor(direction));
        } else {
            this.moveCursorBy(direction);
        }
        return true;
    }

    private boolean handleHomeEnd(int key) {
        int position;
        int n = position = key == 199 ? 0 : this.text.length();
        if (GuiScreen.func_146272_n()) {
            this.setSelectionEnd(position);
        } else {
            this.setCursorPosition(position);
        }
        return true;
    }

    private boolean handleDelete(int key) {
        int direction;
        int n = direction = key == 14 ? -1 : 1;
        if (GuiScreen.func_146271_m()) {
            this.deleteWords(direction);
        } else {
            this.deleteFromCursor(direction);
        }
        return true;
    }

    @Override
    public void onFocus() {
        this.setCursorPosition(this.text.length());
        this.cursorBlinkCounter = 0;
    }

    @Override
    protected void drawSelf(int mx, int my) {
        boolean cursorBeforeEnd;
        int color = this.enabled ? this.textColor : this.textColorDisabled;
        int drawWidth = this.getInternalWidth();
        int drawX = this.x;
        int drawY = this.y;
        String visibleString = this.mc.field_71466_p.func_78269_a(this.text.substring(this.scrollOffset), drawWidth);
        int relativeCursorPosition = this.cursorPosition - this.scrollOffset;
        int relativeSelectionEnd = this.selectionEnd - this.scrollOffset;
        boolean cursorVisible = relativeCursorPosition >= 0 && relativeCursorPosition <= visibleString.length();
        boolean bl = cursorBeforeEnd = this.cursorPosition < this.text.length() || this.text.length() >= this.maxTextLength;
        if (relativeSelectionEnd > visibleString.length()) {
            relativeSelectionEnd = visibleString.length();
        }
        int textX = drawX;
        if (visibleString.length() > 0) {
            String s1 = cursorVisible ? visibleString.substring(0, relativeCursorPosition) : visibleString;
            this.mc.field_71446_o.func_110577_a(TEXTURE);
            textX = this.mc.field_71466_p.func_175065_a(s1, (float)textX, (float)drawY, color, this.shadow);
        }
        int cursorX = textX--;
        if (!cursorVisible) {
            cursorX = relativeCursorPosition > 0 ? drawX + this.width : drawX;
        } else if (cursorBeforeEnd) {
            if (this.shadow) {
                // empty if block
            }
            cursorX = textX;
        }
        if (visibleString.length() > 0 && cursorVisible && relativeCursorPosition < visibleString.length()) {
            this.mc.field_71446_o.func_110577_a(TEXTURE);
            this.mc.field_71466_p.func_175065_a(visibleString.substring(relativeCursorPosition), (float)textX, (float)drawY, color, this.shadow);
        }
        if (this.isFocus() && cursorVisible && this.cursorBlinkCounter / 6 % 2 == 0) {
            if (cursorBeforeEnd) {
                TextField.func_73734_a((int)cursorX, (int)(drawY - 1), (int)(cursorX + 1), (int)(drawY + 1 + this.mc.field_71466_p.field_78288_b), (int)-3092272);
            } else {
                this.mc.field_71446_o.func_110577_a(TEXTURE);
                this.mc.field_71466_p.func_175065_a("_", (float)cursorX, (float)drawY, color, this.shadow);
            }
        }
        if (relativeSelectionEnd != relativeCursorPosition) {
            int selectedDrawX = drawX + this.mc.field_71466_p.func_78256_a(visibleString.substring(0, relativeSelectionEnd));
            int selectionStartX = Math.min(cursorX, selectedDrawX - 1);
            int selectionEndX = Math.max(cursorX, selectedDrawX - 1);
            if (selectionStartX > this.x + this.width) {
                selectionStartX = this.x + this.width;
            }
            if (selectionEndX > this.x + this.width) {
                selectionEndX = this.x + this.width;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179115_u();
            GlStateManager.func_179116_f((int)5387);
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldrenderer.func_181662_b((double)selectionStartX, (double)drawY + 1.0 + (double)this.mc.field_71466_p.field_78288_b, 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)selectionEndX, (double)drawY + 1.0 + (double)this.mc.field_71466_p.field_78288_b, 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)selectionEndX, (double)drawY - 1.0, 0.0).func_181675_d();
            worldrenderer.func_181662_b((double)selectionStartX, (double)drawY - 1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179134_v();
            GlStateManager.func_179098_w();
        }
    }

    @Override
    public void putInside(View view) {
        super.putInside(view);
        this.setSelectionEnd(this.selectionEnd);
    }

    @Override
    public void handleClick(int mx, int my) {
        if (mx < 0) {
            return;
        }
        String visibleString = this.mc.field_71466_p.func_78269_a(this.text.substring(this.scrollOffset), this.getInternalWidth());
        String trimmedString = this.mc.field_71466_p.func_78269_a(visibleString, mx);
        int oldScrollOffset = this.scrollOffset;
        this.setFocus();
        this.scrollOffset = oldScrollOffset;
        this.setCursorPosition(trimmedString.length() + this.scrollOffset);
    }

    @Override
    public boolean onKeyTyped(char c, int key) {
        switch (c) {
            case '\u0001': {
                this.setCursorPosition(this.text.length());
                this.setSelectionEnd(0);
                return true;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return true;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                this.writeText("");
                return true;
            }
        }
        return this.handleKey(c, key);
    }

    @Override
    public void onUpdate() {
        ++this.cursorBlinkCounter;
    }

    public void writeText(String str) {
        int insertedLength;
        String filteredStr = this.filter.filter(str);
        int insertAt = Math.min(this.cursorPosition, this.selectionEnd);
        int insertEnd = Math.max(this.cursorPosition, this.selectionEnd);
        int availableChars = this.maxTextLength - this.text.length() + (insertEnd - insertAt);
        String result = "";
        if (this.text.length() > 0 && insertAt > 0) {
            result = this.text.substring(0, insertAt);
        }
        if (availableChars < filteredStr.length()) {
            result = result + filteredStr.substring(0, availableChars);
            insertedLength = availableChars;
        } else {
            result = result + filteredStr;
            insertedLength = filteredStr.length();
        }
        if (this.text.length() > 0 && insertEnd < this.text.length()) {
            result = result + this.text.substring(insertEnd);
        }
        this.text = result;
        this.moveCursorBy(insertAt - this.selectionEnd + insertedLength);
    }

    public void deleteWords(int count) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(count) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int count) {
        if (this.text.length() == 0) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean backwards = count < 0;
            int start = backwards ? this.cursorPosition + count : this.cursorPosition;
            int end = backwards ? this.cursorPosition : this.cursorPosition + count;
            String result = "";
            if (start > 0) {
                result = this.text.substring(0, start);
            }
            if (end < this.text.length()) {
                result = result + this.text.substring(end);
            }
            this.text = result;
            if (backwards) {
                this.moveCursorBy(count);
            }
        }
    }

    public int getNthWordFromPos(int count, int pos) {
        boolean reverse = count < 0;
        int position = pos;
        for (int i1 = 0; i1 < Math.abs(count); ++i1) {
            if (reverse) {
                while (position > 0 && this.text.charAt(position - 1) == ' ') {
                    --position;
                }
                while (position > 0 && this.text.charAt(position - 1) != ' ') {
                    --position;
                }
                continue;
            }
            if ((position = this.text.indexOf(32, position)) == -1) {
                position = this.text.length();
                continue;
            }
            while (position < this.text.length() && this.text.charAt(position) == ' ') {
                ++position;
            }
        }
        return position;
    }

    public int getNthWordFromCursor(int count) {
        return this.getNthWordFromPos(count, this.cursorPosition);
    }

    public static interface Filter {
        public String filter(String var1);

        public boolean isAllowedCharacter(char var1);
    }
}

