/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.controls.Button;
import com.minecolonies.MineColonies;
import com.minecolonies.client.gui.AbstractWindowSkeleton;
import com.minecolonies.colony.Schematics;
import com.minecolonies.network.messages.BuildToolPlaceMessage;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.SchematicWrapper;
import com.schematica.Settings;
import com.schematica.client.renderer.RenderSchematic;
import com.schematica.client.util.RotationHelper;
import com.schematica.world.storage.Schematic;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowBuildTool
extends AbstractWindowSkeleton {
    private static final String BUTTON_TYPE_ID = "buildingType";
    private static final String BUTTON_HUT_DEC_ID = "hutDec";
    private static final String BUTTON_STYLE_ID = "style";
    private static final String BUTTON_LEVEL_ID = "level";
    private static final String BUTTON_CONFIRM = "confirm";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_ROTATE_LEFT = "rotateLeft";
    private static final String BUTTON_ROTATE_RIGHT = "rotateRight";
    private static final String BUTTON_UP = "up";
    private static final String BUTTON_DOWN = "down";
    private static final String BUTTON_FORWARD = "forward";
    private static final String BUTTON_BACK = "back";
    private static final String BUTTON_LEFT = "left";
    private static final String BUTTON_RIGHT = "right";
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowBuildTool.xml";
    private static final String HUT_PREFIX = ":blockHut";
    private static final BlockPos DEFAULT_POS = new BlockPos(0, 0, 0);
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_LEFT = 3;
    @NotNull
    private List<String> hutDec = new ArrayList<String>();
    private int hutDecIndex = 0;
    private int styleIndex = 0;
    @NotNull
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
    private int rotation = 0;
    private int level = 0;

    public WindowBuildTool(@NotNull BlockPos pos) {
        super("minecolonies:gui/windowBuildTool.xml");
        Schematic schematic = Settings.instance.getActiveSchematic();
        if (schematic != null) {
            BlockPosUtil.set(this.pos, Settings.instance.getOffset().func_177971_a((Vec3i)schematic.getOffset()));
            this.rotation = Settings.instance.getRotation();
            this.level = Settings.instance.getLevel();
        } else {
            BlockPosUtil.set(this.pos, pos);
        }
        this.registerButton(BUTTON_TYPE_ID, this::placementModeClicked);
        this.registerButton(BUTTON_HUT_DEC_ID, this::hutDecClicked);
        this.registerButton(BUTTON_STYLE_ID, this::styleClicked);
        this.registerButton(BUTTON_LEVEL_ID, this::levelClicked);
        this.registerButton(BUTTON_CONFIRM, this::confirmClicked);
        this.registerButton(BUTTON_CANCEL, this::cancelClicked);
        this.registerButton(BUTTON_LEFT, this::moveLeftClicked);
        this.registerButton(BUTTON_RIGHT, this::moveRightClicked);
        this.registerButton(BUTTON_BACK, this::moveBackClicked);
        this.registerButton(BUTTON_FORWARD, this::moveForwardClicked);
        this.registerButton(BUTTON_UP, this::moveUpClicked);
        this.registerButton(BUTTON_DOWN, this::moveDownClicked);
        this.registerButton(BUTTON_ROTATE_RIGHT, this::rotateRightClicked);
        this.registerButton(BUTTON_ROTATE_LEFT, this::rotateLeftClicked);
    }

    private static boolean inventoryHasHut(@NotNull InventoryPlayer inventory, String hut) {
        return inventory.func_146028_b(Block.func_149684_b((String)("minecolonies:blockHut" + hut)).func_180665_b(null, DEFAULT_POS));
    }

    @Override
    public void onOpened() {
        if (Settings.instance.isInHutMode()) {
            this.loadHutMode();
        } else {
            this.loadDecorationMode();
        }
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveSchematic() != null) {
            Settings.instance.setSchematicInfo(this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class).getLabel(), this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).getLabel(), this.level, this.rotation);
        }
    }

    private void loadDecorationMode() {
        this.findPaneOfTypeByID(BUTTON_TYPE_ID, Button.class).setLabel(LanguageHandler.getString("com.minecolonies.gui.buildtool.decoration"));
        this.hutDec.addAll(Schematics.getDecorations());
        this.setupButtons();
    }

    private void loadHutMode() {
        this.findPaneOfTypeByID(BUTTON_TYPE_ID, Button.class).setLabel(LanguageHandler.getString("com.minecolonies.gui.buildtool.hut"));
        InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
        this.hutDec.addAll(Schematics.getHuts().stream().filter(hut -> WindowBuildTool.inventoryHasHut(inventory, hut) && Schematics.getStylesForHut(hut) != null).collect(Collectors.toList()));
        this.setupButtons();
    }

    private void setupButtons() {
        if (this.hutDec.isEmpty()) {
            Button buttonHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class);
            buttonHutDec.setLabel(LanguageHandler.getString(Settings.instance.isInHutMode() ? "com.minecolonies.gui.buildtool.nohut" : "com.minecolonies.gui.buildtool.nodecoration"));
            buttonHutDec.setEnabled(false);
            Settings.instance.setActiveSchematic(null);
        } else {
            if (Settings.instance.getActiveSchematic() != null) {
                this.hutDecIndex = Math.max(0, this.hutDec.indexOf(Settings.instance.getHutDec()));
                this.styleIndex = Math.max(0, this.getStyles().indexOf(Settings.instance.getStyle()));
            }
            Button buttonHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class);
            buttonHutDec.setLabel(this.hutDec.get(this.hutDecIndex));
            buttonHutDec.setEnabled(true);
            Button buttonStyle = this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class);
            buttonStyle.setVisible(true);
            buttonStyle.setLabel(this.getStyles().get(this.styleIndex));
            if (Settings.instance.getActiveSchematic() == null) {
                this.rotation = 0;
                this.level = 0;
                this.changeSchematic();
            }
            this.updateLevelButton();
        }
    }

    private void placementModeClicked(Button button) {
        Settings.instance.setActiveSchematic(null);
        this.hutDec.clear();
        this.hutDecIndex = 0;
        this.styleIndex = 0;
        if (Settings.instance.isInHutMode()) {
            Settings.instance.setInHutMode(false);
            this.loadDecorationMode();
        } else {
            Settings.instance.setInHutMode(true);
            this.loadHutMode();
        }
    }

    private void hutDecClicked(@NotNull Button button) {
        if (this.hutDec.size() == 1) {
            return;
        }
        this.hutDecIndex = (this.hutDecIndex + 1) % this.hutDec.size();
        this.styleIndex = 0;
        button.setLabel(this.hutDec.get(this.hutDecIndex));
        this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).setLabel(this.getStyles().get(this.styleIndex));
        this.rotation = 0;
        this.level = 0;
        this.changeSchematic();
    }

    private List<String> getStyles() {
        if (Settings.instance.isInHutMode()) {
            return Schematics.getStylesForHut(this.hutDec.get(this.hutDecIndex));
        }
        return Schematics.getStylesForDecoration(this.hutDec.get(this.hutDecIndex));
    }

    private void changeSchematic() {
        String labelHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class).getLabel();
        String labelHutStyle = this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).getLabel();
        SchematicWrapper schematic = new SchematicWrapper((World)this.mc.field_71441_e, labelHutStyle + '/' + labelHutDec + (Settings.instance.isInHutMode() ? Integer.valueOf(this.level + 1) : ""));
        Settings.instance.setActiveSchematic(schematic.getSchematic());
        Settings.instance.moveTo((BlockPos)this.pos);
        if (this.rotation == 3) {
            RotationHelper.rotate(Settings.instance.getSchematicWorld(), EnumFacing.DOWN, true);
        } else {
            for (int times = 0; times < this.rotation; ++times) {
                RotationHelper.rotate(Settings.instance.getSchematicWorld(), EnumFacing.UP, true);
            }
        }
    }

    private void styleClicked(@NotNull Button button) {
        List<String> styles = this.getStyles();
        if (styles.size() == 1) {
            return;
        }
        this.styleIndex = (this.styleIndex + 1) % styles.size();
        button.setLabel(styles.get(this.styleIndex));
        this.changeSchematic();
    }

    private void levelClicked(Button button) {
        int maxLevel = Schematics.getMaxLevelForHut(this.hutDec.get(this.hutDecIndex));
        if (maxLevel > 1) {
            this.level = (this.level + 1) % maxLevel;
            this.updateLevelButton();
            this.changeSchematic();
        }
    }

    private void updateLevelButton() {
        Button buttonLevel = this.findPaneOfTypeByID(BUTTON_LEVEL_ID, Button.class);
        if (Settings.instance.isInHutMode()) {
            buttonLevel.setVisible(true);
            buttonLevel.setLabel("Level: " + (this.level + 1));
        } else {
            buttonLevel.setVisible(false);
        }
    }

    private void confirmClicked(Button button) {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildToolPlaceMessage(this.hutDec.get(this.hutDecIndex), this.getStyles().get(this.styleIndex), (BlockPos)this.pos, this.rotation, Settings.instance.isInHutMode()));
        Settings.instance.setActiveSchematic(null);
        this.close();
    }

    private void cancelClicked(Button button) {
        Settings.instance.setActiveSchematic(null);
        this.close();
    }

    private void moveLeftClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
        this.updatePosition();
    }

    private void updatePosition() {
        Settings.instance.moveTo((BlockPos)this.pos);
        RenderSchematic.INSTANCE.refresh();
    }

    private void moveRightClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
        this.updatePosition();
    }

    private void moveForwardClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177972_a(this.mc.field_71439_g.func_174811_aO()));
        this.updatePosition();
    }

    private void moveBackClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
        this.updatePosition();
    }

    private void moveUpClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177984_a());
        this.updatePosition();
    }

    private void moveDownClicked(Button button) {
        BlockPosUtil.set(this.pos, this.pos.func_177977_b());
        this.updatePosition();
    }

    private void rotateRightClicked(Button button) {
        this.rotation = (this.rotation + 1) % 4;
        RotationHelper.rotate(Settings.instance.getSchematicWorld(), EnumFacing.UP, true);
        this.updatePosition();
    }

    private void rotateLeftClicked(Button button) {
        this.rotation = (this.rotation + 3) % 4;
        RotationHelper.rotate(Settings.instance.getSchematicWorld(), EnumFacing.DOWN, true);
        this.updatePosition();
    }
}

