/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.blocks.BlockHutBaker;
import com.minecolonies.blocks.BlockHutBlacksmith;
import com.minecolonies.blocks.BlockHutBuilder;
import com.minecolonies.blocks.BlockHutCitizen;
import com.minecolonies.blocks.BlockHutFarmer;
import com.minecolonies.blocks.BlockHutFisherman;
import com.minecolonies.blocks.BlockHutLumberjack;
import com.minecolonies.blocks.BlockHutMiner;
import com.minecolonies.blocks.BlockHutStonemason;
import com.minecolonies.blocks.BlockHutTownHall;
import com.minecolonies.blocks.BlockHutWarehouse;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.BuildingBaker;
import com.minecolonies.colony.buildings.BuildingBlacksmith;
import com.minecolonies.colony.buildings.BuildingBuilder;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.buildings.BuildingFisherman;
import com.minecolonies.colony.buildings.BuildingHome;
import com.minecolonies.colony.buildings.BuildingLumberjack;
import com.minecolonies.colony.buildings.BuildingMiner;
import com.minecolonies.colony.buildings.BuildingStonemason;
import com.minecolonies.colony.buildings.BuildingTownHall;
import com.minecolonies.colony.buildings.BuildingWarehouse;
import com.minecolonies.colony.materials.MaterialStore;
import com.minecolonies.colony.workorders.WorkOrderBuild;
import com.minecolonies.tileentities.TileEntityColonyBuilding;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding {
    private static final String TAG_BUILDING_TYPE = "type";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_BUILDING_LEVEL = "level";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_STYLE = "style";
    @NotNull
    private static Map<String, Class<?>> nameToClassMap = new HashMap();
    @NotNull
    private static Map<Class<?>, String> classToNameMap = new HashMap();
    @NotNull
    private static Map<Class<?>, Class<?>> blockClassToBuildingClassMap = new HashMap();
    @NotNull
    private static Map<Integer, Class<?>> classNameHashToClassMap = new HashMap();
    private final BlockPos location;
    @NotNull
    private final Colony colony;
    private MaterialStore materialStore;
    private TileEntityColonyBuilding tileEntity;
    private int buildingLevel = 0;
    private int rotation = 0;
    private String style = "classic";
    private boolean dirty = false;

    protected AbstractBuilding(@NotNull Colony colony, BlockPos pos) {
        this.location = pos;
        this.colony = colony;
        this.materialStore = new MaterialStore(MaterialStore.Type.CHEST, colony.getMaterialSystem());
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractBuilding> buildingClass, @NotNull Class<? extends AbstractBlockHut> parentBlock) {
        if (nameToClassMap.containsKey(name) || classNameHashToClassMap.containsKey(buildingClass.getName().hashCode())) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding AbstractBuilding class mapping");
        }
        try {
            if (buildingClass.getDeclaredConstructor(Colony.class, BlockPos.class) != null) {
                nameToClassMap.put(name, buildingClass);
                classToNameMap.put(buildingClass, name);
                classNameHashToClassMap.put(buildingClass.getName().hashCode(), buildingClass);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding AbstractBuilding class mapping", exception);
        }
        if (blockClassToBuildingClassMap.containsKey(parentBlock)) {
            throw new IllegalArgumentException("AbstractBuilding type '" + name + "' uses TileEntity '" + parentBlock.getClass().getName() + "' which is already in use.");
        }
        blockClassToBuildingClassMap.put(parentBlock, buildingClass);
    }

    @Nullable
    public static AbstractBuilding createFromNBT(Colony colony, @NotNull NBTTagCompound compound) {
        AbstractBuilding building = null;
        Class<?> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.func_74779_i(TAG_BUILDING_TYPE));
            if (oclass != null) {
                BlockPos pos = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
                Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
                building = (AbstractBuilding)constructor.newInstance(colony, pos);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.logger.error((Object)exception);
        }
        if (building != null) {
            try {
                building.readFromNBT(compound);
            }
            catch (RuntimeException ex) {
                Log.logger.error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_BUILDING_TYPE), oclass.getName()), (Throwable)ex);
                building = null;
            }
        } else {
            Log.logger.warn(String.format("Unknown Building type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_BUILDING_TYPE)));
        }
        return building;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.buildingLevel = compound.func_74762_e(TAG_BUILDING_LEVEL);
        this.rotation = compound.func_74762_e(TAG_ROTATION);
        this.style = compound.func_74779_i(TAG_STYLE);
        if ("".equals(this.style)) {
            Log.logger.warn("Loaded empty style, setting to classic");
            this.style = "classic";
        }
    }

    @Nullable
    public static AbstractBuilding create(Colony colony, @NotNull TileEntityColonyBuilding parent) {
        AbstractBuilding building = null;
        try {
            Class<?> oclass = blockClassToBuildingClassMap.get(parent.func_145838_q().getClass());
            if (oclass != null) {
                BlockPos loc = parent.getPosition();
                Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
                building = (AbstractBuilding)constructor.newInstance(colony, loc);
            } else {
                Log.logger.error(String.format("TileEntity %s does not have an associated Building.", ((Object)((Object)parent)).getClass().getName()));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.logger.error(String.format("Unknown Building type '%s' or missing constructor of proper format.", ((Object)((Object)parent)).getClass().getName()), (Throwable)exception);
        }
        return building;
    }

    @Nullable
    public static View createBuildingView(ColonyView colony, BlockPos id, @NotNull ByteBuf buf) {
        Class<?> oclass;
        View view;
        block7: {
            view = null;
            oclass = null;
            try {
                int typeHash = buf.readInt();
                oclass = classNameHashToClassMap.get(typeHash);
                if (oclass == null) break block7;
                for (Class<?> c : oclass.getDeclaredClasses()) {
                    if (!c.getName().endsWith("$View")) continue;
                    Constructor<?> constructor = c.getDeclaredConstructor(ColonyView.class, BlockPos.class);
                    view = (View)constructor.newInstance(colony, id);
                    break;
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                Log.logger.error((Object)exception);
            }
        }
        if (view != null) {
            try {
                view.deserialize(buf);
            }
            catch (IndexOutOfBoundsException ex) {
                Log.logger.error(String.format("A AbstractBuilding View (%s) has thrown an exception during deserializing, its state cannot be restored. Report this to the mod author", oclass.getName()), (Throwable)ex);
                view = null;
            }
        } else {
            Log.logger.warn("Unknown AbstractBuilding type, missing View subclass, or missing constructor of proper format.");
        }
        return view;
    }

    public abstract String getSchematicName();

    public boolean isMatchingBlock(@NotNull Block block) {
        Class<?> c = blockClassToBuildingClassMap.get(block.getClass());
        return this.getClass().equals(c);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a(TAG_BUILDING_TYPE, s);
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        compound.func_74768_a(TAG_BUILDING_LEVEL, this.buildingLevel);
        compound.func_74768_a(TAG_ROTATION, this.rotation);
        compound.func_74778_a(TAG_STYLE, this.style);
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public TileEntityColonyBuilding getTileEntity() {
        TileEntity te;
        if (this.tileEntity == null && this.colony.getWorld().func_180495_p(this.location).func_177230_c() != null && (te = this.getColony().getWorld().func_175625_s(this.location)) instanceof TileEntityColonyBuilding) {
            this.tileEntity = (TileEntityColonyBuilding)te;
            if (this.tileEntity.getBuilding() == null) {
                this.tileEntity.setColony(this.colony);
                this.tileEntity.setBuilding(this);
            }
        }
        return this.tileEntity;
    }

    @NotNull
    public Colony getColony() {
        return this.colony;
    }

    public void setTileEntity(TileEntityColonyBuilding te) {
        this.tileEntity = te;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public final void destroy() {
        this.onDestroyed();
        this.colony.removeBuilding(this);
    }

    public void onDestroyed() {
    }

    public void removeCitizen(CitizenData citizen) {
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public void requestUpgrade() {
        if (this.buildingLevel < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.buildingLevel + 1);
        }
    }

    private void requestWorkOrder(int level) {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        this.colony.getWorkManager().addWorkOrder(new WorkOrderBuild(this, level));
        LanguageHandler.sendPlayersLocalizedMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.workOrderAdded", new Object[0]);
    }

    public BlockPos getID() {
        return this.location;
    }

    public void requestRepair() {
        if (this.buildingLevel > 0) {
            this.requestWorkOrder(this.buildingLevel);
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public MaterialStore getMaterialStore() {
        return this.materialStore;
    }

    public void onUpgradeComplete(int newLevel) {
    }

    public void serializeToView(@NotNull ByteBuf buf) {
        buf.writeInt(this.getClass().getName().hashCode());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.buildingLevel = level;
        this.markDirty();
        ColonyManager.markDirty();
    }

    public abstract int getMaxBuildingLevel();

    public final void markDirty() {
        this.dirty = true;
        this.colony.markBuildingsDirty();
    }

    static {
        AbstractBuilding.addMapping("Baker", BuildingBaker.class, BlockHutBaker.class);
        AbstractBuilding.addMapping("Blacksmith", BuildingBlacksmith.class, BlockHutBlacksmith.class);
        AbstractBuilding.addMapping("Builder", BuildingBuilder.class, BlockHutBuilder.class);
        AbstractBuilding.addMapping("Home", BuildingHome.class, BlockHutCitizen.class);
        AbstractBuilding.addMapping("Farmer", BuildingFarmer.class, BlockHutFarmer.class);
        AbstractBuilding.addMapping("Lumberjack", BuildingLumberjack.class, BlockHutLumberjack.class);
        AbstractBuilding.addMapping("Miner", BuildingMiner.class, BlockHutMiner.class);
        AbstractBuilding.addMapping("Stonemason", BuildingStonemason.class, BlockHutStonemason.class);
        AbstractBuilding.addMapping("TownHall", BuildingTownHall.class, BlockHutTownHall.class);
        AbstractBuilding.addMapping("Warehouse", BuildingWarehouse.class, BlockHutWarehouse.class);
        AbstractBuilding.addMapping("Fisherman", BuildingFisherman.class, BlockHutFisherman.class);
    }

    public static class View {
        private final ColonyView colony;
        @NotNull
        private final BlockPos location;
        private int buildingLevel = 0;
        private int buildingMaxLevel = 0;

        protected View(ColonyView c, @NotNull BlockPos l) {
            this.colony = c;
            this.location = new BlockPos((Vec3i)l);
        }

        @NotNull
        public BlockPos getID() {
            return this.location;
        }

        @NotNull
        public BlockPos getLocation() {
            return this.location;
        }

        public ColonyView getColony() {
            return this.colony;
        }

        public int getBuildingLevel() {
            return this.buildingLevel;
        }

        public int getBuildingMaxLevel() {
            return this.buildingMaxLevel;
        }

        public boolean isBuildingMaxLevel() {
            return this.buildingLevel >= this.buildingMaxLevel;
        }

        public void openGui() {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }

        @Nullable
        public Window getWindow() {
            return null;
        }

        public void deserialize(@NotNull ByteBuf buf) {
            this.buildingLevel = buf.readInt();
            this.buildingMaxLevel = buf.readInt();
        }
    }
}

