/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobLumberjack;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractBuildingWorker {
    private static final int MAX_BUILDING_LEVEL = 3;
    private static final String LUMBERJACK = "Lumberjack";
    private static final String LUMBERJACK_HUT_NAME = "lumberjackHut";

    public BuildingLumberjack(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    @NotNull
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingLumberjack.LUMBERJACK_HUT_NAME);
        }
    }
}

