/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.farmer;

import com.minecolonies.blocks.BlockHutField;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.jobs.JobFarmer;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.entity.ai.citizen.farmer.Field;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.Utils;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final int STANDARD_DELAY = 5;
    private static final int DELAY_DIVIDER = 10;
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    private int workingDelay = 5 - this.worker.getLevel() / 10;
    private boolean requestSeeds = true;
    private boolean shouldTryToGetSeed = true;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForFarming), new AITarget(AIState.FARMER_HOE, this::hoe), new AITarget(AIState.FARMER_PLANT, this::plant), new AITarget(AIState.FARMER_HARVEST, this::harvest));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    @NotNull
    private AIState prepareForFarming() {
        block12: {
            block11: {
                BuildingFarmer building = this.getOwnBuilding();
                if (building == null || building.getBuildingLevel() < 1) {
                    return AIState.PREPARING;
                }
                building.syncWithColony(this.world);
                if (building.getFarmerFields().size() < this.getOwnBuilding().getBuildingLevel() && !building.assignManually()) {
                    this.searchAndAddFields();
                }
                if (building.hasNoFields()) {
                    this.chatSpamFilter.talkWithoutSpam("entity.farmer.noFreeFields", new String[0]);
                    return AIState.PREPARING;
                }
                if (building.getCurrentField() == null && building.getFieldToWorkOn() == null) {
                    building.resetFields();
                    return AIState.IDLE;
                }
                Field currentField = building.getCurrentField();
                if (!currentField.needsWork()) break block11;
                switch (currentField.getFieldStage()) {
                    case EMPTY: {
                        if (!this.checkForHoe()) {
                            return this.walkToBlock(currentField.getLocation()) ? AIState.PREPARING : AIState.FARMER_HOE;
                        }
                        break block12;
                    }
                    case HOED: {
                        if (this.canGoPlanting(currentField, building)) {
                            return this.walkToBlock(currentField.getLocation()) ? AIState.PREPARING : AIState.FARMER_PLANT;
                        }
                        break block12;
                    }
                    case PLANTED: {
                        return this.walkToBlock(currentField.getLocation()) ? AIState.PREPARING : AIState.FARMER_HARVEST;
                    }
                }
                break block12;
            }
            this.getOwnBuilding().setCurrentField(null);
        }
        return AIState.PREPARING;
    }

    private void searchAndAddFields() {
        Field newField;
        Colony colony = this.worker.getColony();
        if (colony != null && (newField = colony.getFreeField(this.worker.func_70005_c_())) != null && this.getOwnBuilding() != null) {
            this.getOwnBuilding().addFarmerFields(newField);
        }
    }

    private boolean canGoPlanting(@NotNull Field currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noSeedSet", new String[0]);
            buildingFarmer.setCurrentField(null);
            return false;
        }
        if (this.shouldTryToGetSeed) {
            if (this.walkToBuilding()) {
                return false;
            }
            this.isInHut(new ItemStack(currentField.getSeed()));
            this.shouldTryToGetSeed = false;
        }
        return true;
    }

    @NotNull
    private AIState hoe() {
        BlockPos position;
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = this.getOwnBuilding().getCurrentField();
        if (this.workingOffset != null) {
            position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_HOE;
            }
            if (this.shouldHoe(position, field)) {
                if (this.checkForHoe()) {
                    return AIState.PREPARING;
                }
                this.equipHoe();
                this.worker.func_71038_i();
                this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
                this.worker.damageItemInHand(1);
                this.mineBlock(position.func_177984_a());
            }
        }
        if (!this.handleOffset(field)) {
            this.resetVariables();
            buildingFarmer.getCurrentField().setNeedsWork(true);
            buildingFarmer.getCurrentField().setFieldStage(Field.FieldStage.HOED);
            return AIState.IDLE;
        }
        position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        if (this.shouldHoe(position, field)) {
            this.mineBlock(position.func_177984_a());
        }
        this.setDelay(this.workingDelay);
        return AIState.FARMER_HOE;
    }

    private boolean shouldHoe(@NotNull BlockPos position, @NotNull Field field) {
        return !field.isNoPartOfField(this.world, position) && !BlockUtils.isBlockSeed(this.world, position.func_177984_a()) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && (this.world.func_180495_p(position).func_177230_c() == Blocks.field_150346_d || this.world.func_180495_p(position).func_177230_c() == Blocks.field_150349_c);
    }

    private void equipHoe() {
        this.worker.setHeldItem(this.getHoeSlot());
    }

    private boolean handleOffset(@NotNull Field field) {
        if (this.workingOffset == null) {
            this.workingOffset = new BlockPos(field.getLengthPlusX(), 0, field.getWidthPlusZ());
        } else {
            if (this.workingOffset.func_177952_p() <= -field.getWidthMinusZ() && this.workingOffset.func_177958_n() <= -field.getLengthMinusX()) {
                this.workingOffset = null;
                return false;
            }
            this.workingOffset = this.workingOffset.func_177958_n() <= -field.getLengthMinusX() ? new BlockPos(field.getLengthPlusX(), 0, this.workingOffset.func_177952_p() - 1) : new BlockPos(this.workingOffset.func_177958_n() - 1, 0, this.workingOffset.func_177952_p());
        }
        return true;
    }

    private void resetVariables() {
        this.requestSeeds = true;
        this.shouldDumpInventory = true;
        this.shouldTryToGetSeed = true;
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotContainingTool(this.getInventory(), "hoe");
    }

    @NotNull
    private AIState plant() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = this.getOwnBuilding().getCurrentField();
        if (this.workingOffset != null) {
            BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_PLANT;
            }
            if (this.shouldPlant(position, field) && !this.plantCrop(field.getSeed(), position) && !this.requestSeeds) {
                this.workingOffset = null;
                this.resetVariables();
                buildingFarmer.getCurrentField().setNeedsWork(false);
                buildingFarmer.getCurrentField().setFieldStage(Field.FieldStage.PLANTED);
                return AIState.IDLE;
            }
        }
        if (!this.handleOffset(field)) {
            return this.terminatePlanting(buildingFarmer, field);
        }
        this.setDelay(this.workingDelay);
        return AIState.FARMER_PLANT;
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull Field field) {
        ItemStack itemStack = BlockUtils.getItemStackFromBlockState(this.world.func_180495_p(position.func_177984_a()));
        if (itemStack != null && itemStack.func_77973_b() == field.getSeed()) {
            this.requestSeeds = false;
        }
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockCrops) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && this.world.func_180495_p(position).func_177230_c() == Blocks.field_150458_ak;
    }

    private boolean plantCrop(Item item, @NotNull BlockPos position) {
        int slot = this.worker.findFirstSlotInInventoryWith(item);
        if (slot != -1) {
            IPlantable seed = (IPlantable)item;
            this.world.func_175656_a(position.func_177984_a(), seed.getPlant((IBlockAccess)this.world, position));
            this.getInventory().func_70298_a(slot, 1);
            this.requestSeeds = false;
            return true;
        }
        return false;
    }

    @NotNull
    private AIState terminatePlanting(@NotNull BuildingFarmer buildingFarmer, @NotNull Field field) {
        if (this.requestSeeds) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.NeedSeed", field.getSeed().func_77653_i(new ItemStack(field.getSeed())));
        } else {
            buildingFarmer.getCurrentField().setNeedsWork(false);
            buildingFarmer.getCurrentField().setFieldStage(Field.FieldStage.PLANTED);
        }
        this.resetVariables();
        return AIState.IDLE;
    }

    @NotNull
    private AIState harvest() {
        BlockPos position;
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || buildingFarmer.getCurrentField() == null) {
            return AIState.PREPARING;
        }
        Field field = this.getOwnBuilding().getCurrentField();
        if (this.workingOffset != null) {
            position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_HARVEST;
            }
            if (this.shouldHarvest(position)) {
                this.worker.addExperience(0.5);
                this.mineBlock(position.func_177984_a());
            }
        }
        if (!this.handleOffset(field)) {
            buildingFarmer.getCurrentField().setNeedsWork(false);
            buildingFarmer.getCurrentField().setFieldStage(Field.FieldStage.EMPTY);
            return AIState.IDLE;
        }
        position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
        if (this.shouldHarvest(position)) {
            this.mineBlock(position.func_177984_a());
        }
        this.setDelay(this.workingDelay);
        return AIState.FARMER_HARVEST;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        IBlockState state = this.world.func_180495_p(position.func_177984_a());
        if (state.func_177230_c() instanceof IGrowable && state.func_177230_c() instanceof BlockCrops) {
            BlockCrops block = (BlockCrops)state.func_177230_c();
            return !block.func_176473_a(this.world, position.func_177984_a(), state, false);
        }
        return false;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    @Override
    protected BuildingFarmer getOwnBuilding() {
        return (BuildingFarmer)this.worker.getWorkBuilding();
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return stack != null && Utils.isHoe(stack);
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

