/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.miner;

import com.minecolonies.colony.buildings.BuildingMiner;
import com.minecolonies.entity.ai.citizen.miner.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Level {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private int depth;
    @NotNull
    private List<Node> nodes = new ArrayList<Node>();
    @Nullable
    private Node ladderNode = null;

    private Level() {
    }

    public Level(@NotNull BuildingMiner buildingMiner, int depth) {
        this.depth = depth;
        this.nodes = new ArrayList<Node>();
        int cobbleX = buildingMiner.getCobbleLocation().func_177958_n();
        int cobbleZ = buildingMiner.getCobbleLocation().func_177952_p();
        BlockPos cobbleCenter = new BlockPos(cobbleX - buildingMiner.getVectorX() * 3, depth, cobbleZ - buildingMiner.getVectorZ() * 3);
        BlockPos ladderCenter = new BlockPos(cobbleX + buildingMiner.getVectorX() * 4, depth, cobbleZ + buildingMiner.getVectorZ() * 4);
        Node cobbleNode = new Node(cobbleCenter.func_177958_n(), cobbleCenter.func_177952_p());
        cobbleNode.setStyle(Node.NodeType.LADDER_BACK);
        this.ladderNode = new Node(ladderCenter.func_177958_n(), ladderCenter.func_177952_p());
        this.ladderNode.setStyle(Node.NodeType.SHAFT);
        this.ladderNode.setStatus(Node.NodeStatus.COMPLETED);
        this.ladderNode.setDirectionNegX(Node.NodeStatus.COMPLETED);
        this.ladderNode.setDirectionPosX(Node.NodeStatus.COMPLETED);
        this.ladderNode.setDirectionNegZ(Node.NodeStatus.COMPLETED);
        this.ladderNode.setDirectionPosZ(Node.NodeStatus.COMPLETED);
        if (buildingMiner.getVectorX() > 0) {
            this.ladderNode.setDirectionNegX(Node.NodeStatus.LADDER);
            cobbleNode.setDirectionPosX(Node.NodeStatus.LADDER);
        } else if (buildingMiner.getVectorX() < 0) {
            this.ladderNode.setDirectionPosX(Node.NodeStatus.LADDER);
            cobbleNode.setDirectionNegX(Node.NodeStatus.LADDER);
        } else if (buildingMiner.getVectorZ() > 0) {
            this.ladderNode.setDirectionNegZ(Node.NodeStatus.LADDER);
            cobbleNode.setDirectionPosZ(Node.NodeStatus.LADDER);
        } else if (buildingMiner.getVectorZ() < 0) {
            this.ladderNode.setDirectionPosZ(Node.NodeStatus.LADDER);
            cobbleNode.setDirectionNegZ(Node.NodeStatus.LADDER);
        }
        this.nodes.add(cobbleNode);
        this.nodes.add(this.ladderNode);
    }

    @NotNull
    public static Level createFromNBT(@NotNull NBTTagCompound compound) {
        Level level = new Level();
        level.depth = compound.func_74762_e(TAG_DEPTH);
        NBTTagList nodeTagList = compound.func_150295_c(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.func_74745_c(); ++i) {
            Node node2 = Node.createFromNBT(nodeTagList.func_150305_b(i));
            level.nodes.add(node2);
        }
        int ladderx = compound.func_74762_e(TAG_LADDERX);
        int ladderz = compound.func_74762_e(TAG_LADDERZ);
        level.ladderNode = level.nodes.stream().filter(node -> node.getX() == ladderx && node.getZ() == ladderz).findFirst().orElseThrow(() -> new IllegalStateException("No ladder node found."));
        return level;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Level{");
        sb.append("depth=").append(this.depth);
        sb.append(", nodes=").append(this.nodes);
        sb.append(", ladderNode=").append(this.ladderNode);
        sb.append('}');
        return sb.toString();
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a(TAG_DEPTH, this.depth);
        NBTTagList nodeTagList = new NBTTagList();
        for (Node node : this.nodes) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            node.writeToNBT(nodeCompound);
            nodeTagList.func_74742_a((NBTBase)nodeCompound);
        }
        compound.func_74782_a(TAG_NODES, (NBTBase)nodeTagList);
        compound.func_74768_a(TAG_LADDERX, this.ladderNode.getX());
        compound.func_74768_a(TAG_LADDERZ, this.ladderNode.getZ());
    }

    @NotNull
    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getDepth() {
        return this.depth;
    }

    @Nullable
    public Node getLadderNode() {
        return this.ladderNode;
    }

    public void addNode(Node newnode) {
        this.nodes.add(newnode);
    }
}

