/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.miner;

import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Node {
    private static final String TAG_X = "idX";
    private static final String TAG_Z = "idZ";
    private static final String TAG_STYLE = "Style";
    private static final String TAG_STATUS = "Status";
    private static final String TAG_STATUS_POSITIVE_X = "positiveX";
    private static final String TAG_STATUS_NEGATIVE_X = "negativeX";
    private static final String TAG_STATUS_POSITIVE_Z = "positiveZ";
    private static final String TAG_STATUS_NEGATIVE_Z = "negativeZ";
    private int x;
    private int z;
    private NodeType style;
    private NodeStatus status;
    private NodeStatus directionPosX;
    private NodeStatus directionNegX;
    private NodeStatus directionPosZ;
    private NodeStatus directionNegZ;

    public Node(int x, int z) {
        this.x = x;
        this.z = z;
        this.style = NodeType.CROSSROAD;
        this.status = NodeStatus.AVAILABLE;
        this.directionPosX = NodeStatus.AVAILABLE;
        this.directionNegX = NodeStatus.AVAILABLE;
        this.directionPosZ = NodeStatus.AVAILABLE;
        this.directionNegZ = NodeStatus.AVAILABLE;
    }

    @NotNull
    public static Node createFromNBT(@NotNull NBTTagCompound compound) {
        int x = compound.func_74762_e(TAG_X);
        int z = compound.func_74762_e(TAG_Z);
        NodeType style = NodeType.valueOf(compound.func_74779_i(TAG_STYLE));
        NodeStatus status = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS));
        NodeStatus directionPosX = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS_POSITIVE_X));
        NodeStatus directionNegX = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS_NEGATIVE_X));
        NodeStatus directionPosZ = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS_POSITIVE_Z));
        NodeStatus directionNegZ = NodeStatus.valueOf(compound.func_74779_i(TAG_STATUS_NEGATIVE_Z));
        Node node = new Node(x, z);
        node.setStyle(style);
        node.setStatus(status);
        node.setDirectionPosX(directionPosX);
        node.setDirectionNegX(directionNegX);
        node.setDirectionPosZ(directionPosZ);
        node.setDirectionNegZ(directionNegZ);
        return node;
    }

    public NodeStatus getDirectionPosX() {
        return this.directionPosX;
    }

    public void setDirectionPosX(NodeStatus directionPosX) {
        this.directionPosX = directionPosX;
    }

    public NodeStatus getDirectionNegX() {
        return this.directionNegX;
    }

    public void setDirectionNegX(NodeStatus directionNegX) {
        this.directionNegX = directionNegX;
    }

    public NodeStatus getDirectionPosZ() {
        return this.directionPosZ;
    }

    public void setDirectionPosZ(NodeStatus directionPosZ) {
        this.directionPosZ = directionPosZ;
    }

    public NodeStatus getDirectionNegZ() {
        return this.directionNegZ;
    }

    public void setDirectionNegZ(NodeStatus directionNegZ) {
        this.directionNegZ = directionNegZ;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a(TAG_X, this.x);
        compound.func_74768_a(TAG_Z, this.z);
        compound.func_74778_a(TAG_STYLE, this.style.name());
        compound.func_74778_a(TAG_STATUS, this.status.name());
        compound.func_74778_a(TAG_STATUS_POSITIVE_X, this.directionPosX.name());
        compound.func_74778_a(TAG_STATUS_NEGATIVE_X, this.directionNegX.name());
        compound.func_74778_a(TAG_STATUS_POSITIVE_Z, this.directionPosZ.name());
        compound.func_74778_a(TAG_STATUS_NEGATIVE_Z, this.directionNegZ.name());
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Node{");
        sb.append("x=").append(this.x);
        sb.append(", z=").append(this.z);
        sb.append(", style=").append((Object)this.style);
        sb.append(", status=").append((Object)this.status);
        sb.append(", directionPosX=").append((Object)this.directionPosX);
        sb.append(", directionNegX=").append((Object)this.directionNegX);
        sb.append(", directionPosZ=").append((Object)this.directionPosZ);
        sb.append(", directionNegZ=").append((Object)this.directionNegZ);
        sb.append('}');
        return sb.toString();
    }

    public NodeType getStyle() {
        return this.style;
    }

    public void setStyle(NodeType style) {
        this.style = style;
    }

    static enum NodeType {
        SHAFT,
        LADDER_BACK,
        TUNNEL,
        CROSSROAD,
        BEND;

    }

    static enum NodeStatus {
        AVAILABLE,
        IN_PROGRESS,
        COMPLETED,
        WALL,
        LADDER;

    }
}

