/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.blocks.BlockHutField;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.entity.pathfinding.PathPointExtended;
import com.minecolonies.entity.pathfinding.PathResult;
import com.minecolonies.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<PathEntity> {
    protected static final int DEBUG_VERBOSITY_NONE = 0;
    protected static final int DEBUG_VERBOSITY_BASIC = 1;
    protected static final int DEBUG_VERBOSITY_FULL = 2;
    protected static final Object debugNodeMonitor = new Object();
    private static final int SHIFT_SOUTH = 1;
    private static final int SHIFT_WEST = 2;
    private static final int SHIFT_NORTH = 3;
    private static final int SHIFT_EAST = 4;
    @Nullable
    protected static Set<Node> lastDebugNodesVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesNotVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesPath;
    @NotNull
    protected final BlockPos start;
    @NotNull
    protected final IBlockAccess world;
    protected final PathResult result;
    private final int maxRange;
    private final Queue<Node> nodesOpen = new PriorityQueue<Node>(500);
    private final Map<Integer, Node> nodesVisited = new HashMap<Integer, Node>();
    protected boolean debugDrawEnabled = false;
    protected int debugSleepMs = 0;
    @Nullable
    protected Set<Node> debugNodesVisited = null;
    @Nullable
    protected Set<Node> debugNodesNotVisited = null;
    @Nullable
    protected Set<Node> debugNodesPath = null;
    private boolean allowSwimming = true;
    private boolean allowJumpPointSearchTypeWalk = false;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range) {
        this(world, start, end, range, new PathResult());
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result) {
        int minX = Math.min(start.func_177958_n(), end.func_177958_n());
        int minZ = Math.min(start.func_177952_p(), end.func_177952_p());
        int maxX = Math.max(start.func_177958_n(), end.func_177958_n());
        int maxZ = Math.max(start.func_177952_p(), end.func_177952_p());
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 256, maxZ), range);
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (Configurations.pathfindingDebugDraw) {
            this.debugDrawEnabled = true;
            this.debugSleepMs = 0;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
    }

    private static boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder && (dPos.func_177956_o() >= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0);
    }

    public static BlockPos prepareStart(@NotNull EntityLiving entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.field_70163_u, MathHelper.func_76128_c((double)entity.field_70161_v));
        Block b = entity.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c();
        if (entity.func_70090_H()) {
            while (b.func_149688_o().func_76224_d()) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                b = entity.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c();
            }
        } else if (b instanceof BlockFence || b instanceof BlockWall || b instanceof BlockHutField) {
            double dX = entity.field_70165_t - Math.floor(entity.field_70165_t);
            double dZ = entity.field_70161_v - Math.floor(entity.field_70161_v);
            if (dX < 0.1) {
                pos.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            } else if (dX > 0.9) {
                pos.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            if (dZ < 0.1) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            } else if (dZ > 0.9) {
                pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
        }
        return pos.getImmutable();
    }

    private static void setLadderFacing(@NotNull IBlockAccess world, BlockPos pos, @NotNull PathPointExtended p) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockVine) {
            int meta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
            if ((meta >>> 1 & 1) != 0) {
                p.ladderFacing = EnumFacing.SOUTH;
            } else if ((meta >>> 2 & 1) != 0) {
                p.ladderFacing = EnumFacing.WEST;
            } else if ((meta >>> 3 & 1) != 0) {
                p.ladderFacing = EnumFacing.NORTH;
            } else if ((meta >>> 4 & 1) != 0) {
                p.ladderFacing = EnumFacing.EAST;
            }
        } else {
            p.ladderFacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockLadder.field_176382_a);
        }
    }

    private static boolean onALadder(@NotNull Node node, @Nullable Node nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder && nextInPath.pos.func_177958_n() == pos.func_177958_n() && nextInPath.pos.func_177952_p() == pos.func_177952_p();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.func_177958_n() & 0xFFF) << 20 | (pos.func_177956_o() & 0xFF) << 12 | pos.func_177952_p() & 0xFFF;
    }

    protected static double computeCost(Node parent, @NotNull BlockPos dPos, boolean isSwimming) {
        double cost = 1.0;
        if (dPos.func_177956_o() != 0 && (dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0)) {
            cost *= 1.1;
        }
        if (isSwimming) {
            cost *= 5.0;
        }
        return cost;
    }

    private static boolean checkPreconditions(Node node, int newY) {
        if (AbstractPathJob.nodeClosed(node)) {
            return true;
        }
        return newY < 0;
    }

    private static boolean nodeClosed(@Nullable Node node) {
        return node != null && node.closed;
    }

    private static boolean calculateSwimming(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable Node node) {
        return node != null ? node.isSwimming : world.func_180495_p(pos.func_177977_b()).func_177230_c().func_149688_o().func_76224_d();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final PathEntity call() {
        try {
            return this.search();
        }
        catch (RuntimeException e) {
            Log.logger.debug((Object)e);
            return null;
        }
    }

    @Nullable
    protected PathEntity search() {
        Node bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = this.getNodeResultScore(bestNode);
        while (!this.nodesOpen.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node currentNode = this.nodesOpen.poll();
            currentNode.counterVisited = ++this.totalNodesVisited;
            this.addNodeToDebug(currentNode);
            currentNode.closed = true;
            if (Configurations.pathfindingDebugVerbosity == 2) {
                Log.logger.info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.func_177958_n(), currentNode.pos.func_177956_o(), currentNode.pos.func_177952_p(), currentNode.cost, currentNode.score));
            }
            if (this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (nodeResultScore > bestNodeResultScore) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (currentNode.steps <= this.maxRange) {
                this.walkCurrentNode(currentNode);
            }
            if (!this.doDebugSleep()) continue;
            return null;
        }
        PathEntity path = this.finalizePath(bestNode);
        this.handleDebugDraw();
        return path;
    }

    private void addNodeToDebug(Node currentNode) {
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.remove(currentNode);
            this.debugNodesVisited.add(currentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDebugSleep() {
        if (this.debugDrawEnabled && this.debugSleepMs != 0) {
            Object object = debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = new HashSet<Node>(this.debugNodesNotVisited);
                lastDebugNodesVisited = new HashSet<Node>(this.debugNodesVisited);
                lastDebugNodesPath = null;
            }
            if (this.debugSleepMs != 0) {
                try {
                    Thread.sleep(this.debugSleepMs);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return true;
                }
            }
        }
        return false;
    }

    private void walkCurrentNode(@NotNull Node currentNode) {
        BlockPos dPos = new BlockPos(0, 0, 0);
        if (currentNode.parent != null) {
            dPos = currentNode.pos.func_177973_b((Vec3i)currentNode.parent.pos);
        }
        if (AbstractPathJob.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, new BlockPos(0, 1, 0));
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, new BlockPos(0, -1, 0));
        }
        if (dPos.func_177952_p() <= 0) {
            this.walk(currentNode, new BlockPos(0, 0, -1));
        }
        if (dPos.func_177958_n() >= 0) {
            this.walk(currentNode, new BlockPos(1, 0, 0));
        }
        if (dPos.func_177952_p() >= 0) {
            this.walk(currentNode, new BlockPos(0, 0, 1));
        }
        if (dPos.func_177958_n() <= 0) {
            this.walk(currentNode, new BlockPos(-1, 0, 0));
        }
    }

    private boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return (dPos.func_177956_o() <= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0) && this.isLadder(currentNode.pos.func_177977_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    @NotNull
    private Node getAndSetupStartNode() {
        Node startNode = new Node(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.isLadder = true;
        } else if (this.world.func_180495_p(this.start).func_177230_c().func_149688_o().func_76224_d()) {
            startNode.isSwimming = true;
        }
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    @NotNull
    private PathEntity finalizePath(Node targetNode) {
        int pathLength = 0;
        Node node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            node = node.parent;
        }
        PathPoint[] points = new PathPoint[pathLength];
        Node nextInPath = null;
        node = targetNode;
        while (node.parent != null) {
            this.addNodeToDebug(node);
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming) {
                pos.func_177982_a(0, -1, 0);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.isOnLadder = true;
                if (nextInPath.pos.func_177956_o() > pos.func_177956_o()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.isOnLadder = true;
            }
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new PathEntity(points);
    }

    private void doDebugPrinting(@NotNull PathPoint[] points) {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.logger.info("Path found:");
            for (PathPoint p : points) {
                Log.logger.info(String.format("Step: [%d,%d,%d]", p.field_75839_a, p.field_75837_b, p.field_75838_c));
            }
            Log.logger.info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(Node var1);

    protected abstract double getNodeResultScore(Node var1);

    protected final boolean walk(@NotNull Node parent, @NotNull BlockPos dPos) {
        int newY;
        BlockPos pos = parent.pos.func_177971_a((Vec3i)dPos);
        int nodeKey = AbstractPathJob.computeNodeKey(pos);
        Node node = this.nodesVisited.get(nodeKey);
        if (AbstractPathJob.checkPreconditions(node, newY = this.getGroundHeight(parent, pos))) {
            return false;
        }
        if (pos.func_177956_o() != newY && AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos = new BlockPos(pos.func_177958_n(), newY, pos.func_177952_p()))))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        double stepCost = AbstractPathJob.computeCost(parent, dPos, isSwimming);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.cost + stepCost;
        double score = cost + heuristic;
        if (node != null) {
            if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
                return false;
            }
        } else {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(@NotNull Node parent, @NotNull BlockPos dPos, @NotNull Node node) {
        if (this.allowJumpPointSearchTypeWalk && node.heuristic <= parent.heuristic) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private Node createNode(Node parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        Node node = new Node(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.isLadder = true;
        } else if (isSwimming) {
            node.isSwimming = true;
        }
        ++this.totalNodesAdded;
        node.counterAdded = this.totalNodesAdded;
        return node;
    }

    private boolean updateCurrentNode(@NotNull Node parent, @NotNull Node node, double heuristic, double cost, double score) {
        if (score >= node.score) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.steps = parent.steps + 1;
        node.cost = cost;
        node.heuristic = heuristic;
        node.score = score;
        return false;
    }

    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return -1;
        }
        Block target = this.world.func_180495_p(pos).func_177230_c();
        if (!this.isPassable(target, pos)) {
            return this.handleTargeNotPassable(parent, pos, target);
        }
        Block below = this.world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (this.isWalkableSurface(below, pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable Node parent, @NotNull BlockPos pos, @NotNull Block below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming;
        if (below.func_149688_o().func_76224_d()) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below, pos.func_177977_b())) {
            return pos.func_177956_o();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable Node parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder;
        if (!canDrop || isSwimming) {
            return -1;
        }
        Block below = this.world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        if (this.isWalkableSurface(below, pos.func_177979_c(2))) {
            return pos.func_177956_o() - 1;
        }
        return -1;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull Block below, boolean isSwimming) {
        if (isSwimming) {
            return pos.func_177956_o();
        }
        if (this.allowSwimming && below.func_149688_o() == Material.field_151586_h) {
            return pos.func_177956_o();
        }
        return -1;
    }

    private int handleTargeNotPassable(@Nullable Node parent, @NotNull BlockPos pos, @NotNull Block target) {
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder && !parent.isSwimming;
        if (!canJump || !this.isWalkableSurface(target, pos)) {
            return -1;
        }
        if (!this.isPassable(pos.func_177981_b(2))) {
            return -1;
        }
        if (!this.isPassable(parent.pos.func_177981_b(2))) {
            return -1;
        }
        return pos.func_177956_o() + 1;
    }

    private boolean checkHeadBlock(@Nullable Node parent, @NotNull BlockPos pos) {
        Block here;
        if (!this.isPassable(pos.func_177984_a())) {
            return true;
        }
        return parent != null && (here = this.world.func_180495_p(parent.pos.func_177977_b()).func_177230_c()).func_149688_o().func_76224_d() && !this.isPassable(pos);
    }

    protected boolean isPassable(@NotNull Block block, BlockPos pos) {
        if (block.func_149688_o() != Material.field_151579_a) {
            if (block.func_149688_o().func_76230_c()) {
                return block instanceof BlockDoor || block instanceof BlockFenceGate;
            }
            if (block.func_149688_o().func_76224_d()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos) {
        return this.isPassable(this.world.func_180495_p(pos).func_177230_c(), pos);
    }

    protected boolean isWalkableSurface(@NotNull Block block, BlockPos pos) {
        return block.func_149688_o().func_76220_a() && !(block instanceof BlockFence) && !(block instanceof BlockFenceGate) && !(block instanceof BlockWall) && !(block instanceof BlockHutField);
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.world, pos, null);
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.func_180495_p(pos).func_177230_c(), pos);
    }
}

