/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node
implements Comparable<Node> {
    @NotNull
    public final BlockPos pos;
    private final int hash;
    @Nullable
    public Node parent;
    public int counterAdded;
    public int counterVisited;
    public int steps;
    public double cost;
    public double heuristic;
    public double score;
    public boolean closed = false;
    public boolean isLadder = false;
    public boolean isSwimming = false;

    public Node(@NotNull BlockPos pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    public Node(@Nullable Node parent, @NotNull BlockPos pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent != null ? parent.steps + 1 : 0;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.func_177958_n() ^ (pos.func_177952_p() << 12 | pos.func_177952_p() >> 20) ^ pos.func_177956_o() << 24;
    }

    @Override
    public int compareTo(Node o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Node other = (Node)o;
            return this.pos.func_177958_n() == other.pos.func_177958_n() && this.pos.func_177956_o() == other.pos.func_177956_o() && this.pos.func_177952_p() == other.pos.func_177952_p();
        }
        return false;
    }
}

