/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldMessage
implements IMessage,
IMessageHandler<AssignFieldMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean assign;
    private BlockPos field;

    public AssignFieldMessage() {
    }

    public AssignFieldMessage(@NotNull BuildingFarmer.View building, boolean assign, BlockPos field) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.assign = assign;
        this.field = field;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.assign = buf.readBoolean();
        this.field = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.assign);
        BlockPosUtil.writeToByteBuf(buf, this.field);
    }

    @Nullable
    public IMessage onMessage(@NotNull AssignFieldMessage message, @NotNull MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)ctx.getServerHandler().field_147369_b, Permissions.Action.ACCESS_HUTS)) {
                return null;
            }
            BuildingFarmer building = colony.getBuilding(message.buildingId, BuildingFarmer.class);
            if (building != null) {
                if (message.assign) {
                    building.assignField(message.field);
                } else {
                    building.freeField(message.field);
                }
            }
        }
        return null;
    }
}

