/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blocks;

import com.minecolonies.creativetab.ModCreativeTabs;
import com.minecolonies.util.Log;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockBarrel
extends Block {
    private static final int MIN_FULLNESS = 0;
    private static final int MAX_FULLNESS = 16;
    private static final int BARRELSTATE_FILLING = 0;
    private static final int BARRELSTATE_COMPOSTING = 1;
    private static final int BARRELSTATE_DONE = 2;
    private static final PropertyInteger BARRELSTATE = PropertyInteger.func_177719_a((String)"BARRELSTATE", (int)0, (int)2);
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "blockBarrel";
    private static final float RESISTANCE = 1.0f;
    private static final HashMap<BlockPos, Integer> timers = new HashMap();
    private static final HashMap<BlockPos, Integer> fillings = new HashMap();

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(BLOCK_NAME);
        this.func_149663_c(String.format("%s.%s", "minecolonies".toLowerCase(), BLOCK_NAME));
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        GameRegistry.registerBlock((Block)this, (String)BLOCK_NAME);
        this.func_149711_c(5.0f);
        this.func_149752_b(1.0f);
    }

    public void AddItemToBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemStack, IBlockState state, BlockPos pos) {
        this.UseBarrel(worldIn, playerIn, itemStack, state, pos);
    }

    public boolean UseBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemstack, IBlockState state, BlockPos pos) {
        Log.logger.info("block activated");
        int barrelState = (Integer)state.func_177229_b((IProperty)BARRELSTATE);
        int fullness = fillings.getOrDefault(pos, 0);
        Log.logger.info("At this moment bs= " + barrelState + " and fl=" + fullness);
        if ((Integer)state.func_177229_b((IProperty)BARRELSTATE) == 2) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(0)));
            fillings.put(pos, 0);
            Log.logger.info("Set Blockstate to " + worldIn.func_180495_p(pos));
            return true;
        }
        if (itemstack == null) {
            return true;
        }
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151078_bh && barrelState == 0) {
            Log.logger.info("item Consumed");
            --itemstack.field_77994_a;
            if (++fullness >= 16) {
                fullness = 16;
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(1)));
            }
            fillings.put(pos, fullness);
            Log.logger.info("now FULLNESS = " + fullness);
            return true;
        }
        return true;
    }

    public void GetItemFromBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemStack, IBlockState state, BlockPos pos) {
        int bs = (Integer)state.func_177229_b((IProperty)BARRELSTATE);
        if (bs == 2) {
            this.UseBarrel(worldIn, playerIn, null, state, pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BARRELSTATE);
    }

    public boolean func_149662_c() {
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Log.logger.info("UpdateTick called");
        int barrelState = (Integer)state.func_177229_b((IProperty)BARRELSTATE);
        Log.logger.info("now BARRELSTATE = " + barrelState);
        switch ((Integer)state.func_177229_b((IProperty)BARRELSTATE)) {
            case 0: {
                this.checkIfBarrelFull(worldIn, pos, state);
                break;
            }
            case 1: {
                this.doBarrelCompostTick(worldIn, pos, state);
                break;
            }
        }
    }

    private void checkIfBarrelFull(World world, BlockPos pos, IBlockState state) {
        int fullness = fillings.getOrDefault(pos, 0);
        if (fullness >= 16) {
            Log.logger.info("Barrel is full.");
            world.func_175656_a(pos, state.func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(1)));
        }
    }

    private void doBarrelCompostTick(World world, BlockPos pos, IBlockState state) {
        int timer = timers.getOrDefault(pos, 0);
        if (++timer >= 20) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(2)));
            timer = 0;
        }
        timers.put(pos, timer);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        Log.logger.info("block right-clicked");
        ItemStack itemstack = playerIn.field_71071_by.func_70448_g();
        this.UseBarrel(worldIn, playerIn, itemstack, state, pos);
        return true;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BARRELSTATE});
    }
}

