/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony;

import com.minecolonies.colony.ColonyManager;
import com.minecolonies.util.Log;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class Schematics {
    private static final String NULL_STYLE = "schematics";
    private static final String SCHEMATIC_EXTENSION = ".schematic";
    private static final String SCHEMATICS_ASSET_PATH = "/assets/minecolonies/schematics/";
    private static Map<String, List<String>> hutStyleMap = new HashMap<String, List<String>>();
    @NotNull
    private static Map<String, Integer> hutLevelsMap = new HashMap<String, Integer>();
    private static Map<String, List<String>> decorationStyleMap = new HashMap<String, List<String>>();

    private Schematics() {
    }

    public static void init() {
        Schematics.loadStyleMaps();
    }

    private static void loadStyleMaps() {
        block15: {
            try {
                URI uri = ColonyManager.class.getResource(SCHEMATICS_ASSET_PATH).toURI();
                if ("jar".equals(uri.getScheme())) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        Path basePath = fileSystem.getPath(SCHEMATICS_ASSET_PATH, new String[0]);
                        Schematics.loadStyleMaps(basePath);
                        break block15;
                    }
                }
                Path basePath = Paths.get(uri);
                Schematics.loadStyleMaps(basePath);
            }
            catch (IOException | URISyntaxException e) {
                Log.logger.error("Error loading Schematic directory. Things will break!", (Throwable)e);
            }
        }
    }

    private static void loadStyleMaps(Path basePath) throws IOException {
        try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                String style = path.getParent().getFileName().toString();
                if (NULL_STYLE.equals(style) || !path.toString().endsWith(SCHEMATIC_EXTENSION)) continue;
                String filename = path.getFileName().toString().split("\\.schematic")[0];
                String hut = filename.split("\\d+")[0];
                if (Schematics.isSchematicHut(hut)) {
                    Schematics.addHutStyle(hut, style);
                    Schematics.incrementHutMaxLevel(hut);
                    continue;
                }
                Schematics.addDecorationStyle(filename, style);
            }
        }
    }

    private static boolean isSchematicHut(String name) {
        return Block.func_149684_b((String)("minecolonies:blockHut" + name)) != null;
    }

    private static void addHutStyle(String hut, String style) {
        if (!hutStyleMap.containsKey(hut)) {
            hutStyleMap.put(hut, new ArrayList());
        }
        if (!hutStyleMap.get(hut).contains(style)) {
            hutStyleMap.get(hut).add(style);
        }
    }

    private static void incrementHutMaxLevel(String hut) {
        if (Schematics.getStylesForHut(hut).size() > 1) {
            return;
        }
        Integer level = hutLevelsMap.getOrDefault(hut, 0);
        hutLevelsMap.put(hut, level + 1);
    }

    private static void addDecorationStyle(String decoration, String style) {
        if (!decorationStyleMap.containsKey(decoration)) {
            decorationStyleMap.put(decoration, new ArrayList());
        }
        decorationStyleMap.get(decoration).add(style);
    }

    public static List<String> getStylesForHut(String hut) {
        return hutStyleMap.get(hut);
    }

    public static Set<String> getHuts() {
        return hutStyleMap.keySet();
    }

    public static int getMaxLevelForHut(String hut) {
        return hutLevelsMap.getOrDefault(hut, 0);
    }

    public static Set<String> getDecorations() {
        return decorationStyleMap.keySet();
    }

    public static List<String> getStylesForDecoration(String decoration) {
        return decorationStyleMap.get(decoration);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setStyles(Map<String, List<String>> hutStyleMap, Map<String, List<String>> decorationStyleMap) {
        Schematics.hutStyleMap = hutStyleMap;
        Schematics.decorationStyleMap = decorationStyleMap;
    }
}

