/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.workorders.AbstractWorkOrder;
import com.minecolonies.util.Log;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkManager {
    private static final String TAG_WORK_ORDERS = "workOrders";
    private static final int WORK_ORDER_FULFILL_INCREMENT = 20;
    protected final Colony colony;
    @NotNull
    private Map<Integer, AbstractWorkOrder> workOrders = new LinkedHashMap<Integer, AbstractWorkOrder>();
    private int topWorkOrderId = 0;
    private boolean dirty = false;

    public WorkManager(Colony c) {
        this.colony = c;
    }

    public void removeWorkOrder(@NotNull AbstractWorkOrder order) {
        this.removeWorkOrder(order.getID());
    }

    public void removeWorkOrder(int orderId) {
        this.workOrders.remove(orderId);
        this.colony.removeWorkOrder(orderId);
    }

    @Nullable
    public <W extends AbstractWorkOrder> W getWorkOrder(int id, @NotNull Class<W> type) {
        try {
            return (W)((AbstractWorkOrder)type.cast(this.getWorkOrder(id)));
        }
        catch (ClassCastException exc) {
            Log.logger.catching((Throwable)exc);
            return null;
        }
    }

    public AbstractWorkOrder getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Nullable
    public <W extends AbstractWorkOrder> W getUnassignedWorkOrder(@NotNull Class<W> type) {
        for (AbstractWorkOrder o : this.workOrders.values()) {
            if (o.isClaimed() || !type.isAssignableFrom(o.getClass())) continue;
            return (W)((AbstractWorkOrder)type.cast(o));
        }
        return null;
    }

    public <W extends AbstractWorkOrder> List<W> getWorkOrdersOfType(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(o -> type.isAssignableFrom(o.getClass())).map(type::cast).collect(Collectors.toList());
    }

    @NotNull
    public Map<Integer, AbstractWorkOrder> getWorkOrders() {
        return this.workOrders;
    }

    public void clearWorkForCitizen(@NotNull CitizenData citizen) {
        this.dirty = true;
        this.workOrders.values().stream().filter(o -> o.isClaimedBy(citizen)).forEach(AbstractWorkOrder::clearClaimedBy);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (AbstractWorkOrder o : this.workOrders.values()) {
            NBTTagCompound orderCompound = new NBTTagCompound();
            o.writeToNBT(orderCompound);
            list.func_74742_a((NBTBase)orderCompound);
        }
        compound.func_74782_a(TAG_WORK_ORDERS, (NBTBase)list);
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c(TAG_WORK_ORDERS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound orderCompound = list.func_150305_b(i);
            AbstractWorkOrder o = AbstractWorkOrder.createFromNBT(orderCompound);
            if (o == null) continue;
            this.addWorkOrder(o);
            if (o.isClaimed() && this.colony.getCitizen(o.getClaimedBy()) == null) {
                o.clearClaimedBy();
            }
            this.topWorkOrderId = Math.max(this.topWorkOrderId, o.getID());
        }
    }

    public void addWorkOrder(@NotNull AbstractWorkOrder order) {
        this.dirty = true;
        if (order.getID() == 0) {
            ++this.topWorkOrderId;
            order.setID(this.topWorkOrderId);
        }
        this.workOrders.put(order.getID(), order);
    }

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<AbstractWorkOrder> iter = this.workOrders.values().iterator();
            while (iter.hasNext()) {
                AbstractWorkOrder o2 = iter.next();
                if (!o2.isValid(this.colony)) {
                    iter.remove();
                    this.dirty = true;
                    continue;
                }
                if (!o2.hasChanged()) continue;
                this.dirty = true;
                o2.resetChange();
            }
            if (event.world.func_72820_D() % 20L == 0L) {
                this.workOrders.values().stream().filter(o -> !o.isClaimed()).sorted((first, second) -> second.getPriority() > first.getPriority() ? 1 : (second.getPriority() < first.getPriority() ? -1 : 0)).forEach(o -> o.attemptToFulfill(this.colony));
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

