/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutBuilder;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobBuilder;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilder
extends AbstractBuildingWorker {
    private static final int MAX_BUILDING_LEVEL = 2;
    private static final String BUILDER = "Builder";

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 2;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBuilder(this);
        }
    }
}

