/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHomeBuilding;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingHut;
import com.minecolonies.util.ServerUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHome
extends AbstractBuildingHut {
    private static final String TAG_RESIDENTS = "residents";
    private static final String CITIZEN = "Citizen";
    @NotNull
    private List<CitizenData> residents = new ArrayList<CitizenData>();

    public BuildingHome(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CITIZEN;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 4;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        int[] residentIds;
        super.readFromNBT(compound);
        this.residents.clear();
        for (int citizenId : residentIds = compound.func_74759_k(TAG_RESIDENTS)) {
            CitizenData citizen = this.getColony().getCitizen(citizenId);
            if (citizen == null) continue;
            this.residents.add(citizen);
            citizen.setHomeBuilding(this);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (!this.residents.isEmpty()) {
            int[] residentIds = new int[this.residents.size()];
            for (int i = 0; i < this.residents.size(); ++i) {
                residentIds[i] = this.residents.get(i).getId();
            }
            compound.func_74783_a(TAG_RESIDENTS, residentIds);
        }
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        this.getColony().calculateMaxCitizens();
    }

    @Override
    public void onDestroyed() {
        this.residents.stream().filter(citizen -> citizen != null).forEach(citizen -> citizen.setHomeBuilding(null));
        super.onDestroyed();
    }

    @Override
    public void removeCitizen(@NotNull CitizenData citizen) {
        if (this.residents.contains(citizen)) {
            citizen.setHomeBuilding(null);
            this.residents.remove(citizen);
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.residents.size() < this.getMaxInhabitants()) {
            this.addHomelessCitizens();
        }
    }

    @Override
    public int getMaxInhabitants() {
        return 2;
    }

    public void addHomelessCitizens() {
        for (CitizenData citizen : this.getColony().getCitizens().values()) {
            if (citizen.getHomeBuilding() != null) continue;
            this.addResident(citizen);
            if (this.residents.size() < this.getMaxInhabitants()) continue;
            break;
        }
    }

    private void addResident(@NotNull CitizenData citizen) {
        this.residents.add(citizen);
        citizen.setHomeBuilding(this);
        this.markDirty();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        EntityPlayer owner = ServerUtils.getPlayerFromUUID(this.getColony().getPermissions().getOwner());
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingColonist);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeColonistMax);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.residents.size());
        for (CitizenData citizen : this.residents) {
            buf.writeInt(citizen.getId());
        }
    }

    public boolean hasResident(CitizenData citizen) {
        return this.residents.contains(citizen);
    }

    public static class View
    extends AbstractBuildingHut.View {
        @NotNull
        private List<Integer> residents = new ArrayList<Integer>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getResidents() {
            return Collections.unmodifiableList(this.residents);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHomeBuilding(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.residents.add(buf.readInt());
            }
        }
    }
}

