/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.client.gui.WindowHutWarehouse;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobDeliveryman;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingWarehouse
extends AbstractBuildingWorker {
    private static final String WAREHOUSE = "Warehouse";
    private static final String DELIVERYMAN = "Deliveryman";
    private static final String TAG_DELIVERY = "delivery";
    private static final String TAG_BLACKSMITH = "blacksmith";
    private static final String TAG_GOLD = "gold";
    private static final String TAG_DIAMOND = "diamond";
    private static final String TAG_STONEMASON = "stonemason";
    private static final String TAG_STONE = "stone";
    private static final String TAG_SAND = "sand";
    private static final String TAG_NETHERRACK = "netherrack";
    private static final String TAG_QUARTZ = "quartz";
    private static final String TAG_GUARD = "guard";
    private static final String TAG_ARMOR = "armor";
    private static final String TAG_WEAPON = "weapon";
    private static final String TAG_CITIZEN = "citizen";
    public boolean blacksmithGold = false;
    public boolean blacksmithDiamond = false;
    public boolean stonemasonStone = false;
    public boolean stonemasonSand = false;
    public boolean stonemasonNetherrack = false;
    public boolean stonemasonQuartz = false;
    public boolean guardArmor = false;
    public boolean guardWeapon = false;
    public boolean citizenVisit = false;

    public BuildingWarehouse(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 4;
    }

    @Override
    @NotNull
    public String getJobName() {
        return DELIVERYMAN;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobDeliveryman(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagCompound deliveryCompound = compound.func_74775_l(TAG_DELIVERY);
        NBTTagCompound blacksmithCompound = deliveryCompound.func_74775_l(TAG_BLACKSMITH);
        this.blacksmithGold = blacksmithCompound.func_74767_n(TAG_GOLD);
        this.blacksmithDiamond = blacksmithCompound.func_74767_n(TAG_DIAMOND);
        NBTTagCompound stonemasonCompound = deliveryCompound.func_74775_l(TAG_STONEMASON);
        this.stonemasonStone = stonemasonCompound.func_74767_n(TAG_STONE);
        this.stonemasonSand = stonemasonCompound.func_74767_n(TAG_SAND);
        this.stonemasonNetherrack = stonemasonCompound.func_74767_n(TAG_NETHERRACK);
        this.stonemasonQuartz = stonemasonCompound.func_74767_n(TAG_QUARTZ);
        NBTTagCompound guardCompound = deliveryCompound.func_74775_l(TAG_GUARD);
        this.guardArmor = guardCompound.func_74767_n(TAG_ARMOR);
        this.guardWeapon = guardCompound.func_74767_n(TAG_WEAPON);
        this.citizenVisit = deliveryCompound.func_74767_n(TAG_CITIZEN);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound deliveryCompound = new NBTTagCompound();
        NBTTagCompound blacksmithCompound = new NBTTagCompound();
        blacksmithCompound.func_74757_a(TAG_GOLD, this.blacksmithGold);
        blacksmithCompound.func_74757_a(TAG_DIAMOND, this.blacksmithDiamond);
        deliveryCompound.func_74782_a(TAG_BLACKSMITH, (NBTBase)blacksmithCompound);
        NBTTagCompound stonemasonCompound = new NBTTagCompound();
        stonemasonCompound.func_74757_a(TAG_STONE, this.stonemasonStone);
        stonemasonCompound.func_74757_a(TAG_SAND, this.stonemasonSand);
        stonemasonCompound.func_74757_a(TAG_NETHERRACK, this.stonemasonNetherrack);
        stonemasonCompound.func_74757_a(TAG_QUARTZ, this.stonemasonQuartz);
        deliveryCompound.func_74782_a(TAG_STONEMASON, (NBTBase)stonemasonCompound);
        NBTTagCompound guardCompound = new NBTTagCompound();
        guardCompound.func_74757_a(TAG_ARMOR, this.guardArmor);
        guardCompound.func_74757_a(TAG_WEAPON, this.guardWeapon);
        deliveryCompound.func_74782_a(TAG_GUARD, (NBTBase)guardCompound);
        deliveryCompound.func_74757_a(TAG_CITIZEN, this.citizenVisit);
        compound.func_74782_a(TAG_DELIVERY, (NBTBase)deliveryCompound);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.blacksmithGold);
        buf.writeBoolean(this.blacksmithDiamond);
        buf.writeBoolean(this.stonemasonStone);
        buf.writeBoolean(this.stonemasonSand);
        buf.writeBoolean(this.stonemasonNetherrack);
        buf.writeBoolean(this.stonemasonQuartz);
        buf.writeBoolean(this.guardArmor);
        buf.writeBoolean(this.guardWeapon);
        buf.writeBoolean(this.citizenVisit);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public boolean blacksmithGold = false;
        public boolean blacksmithDiamond = false;
        public boolean stonemasonStone = false;
        public boolean stonemasonSand = false;
        public boolean stonemasonNetherrack = false;
        public boolean stonemasonQuartz = false;
        public boolean guardArmor = false;
        public boolean guardWeapon = false;
        public boolean citizenVisit = false;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWarehouse(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.blacksmithGold = buf.readBoolean();
            this.blacksmithDiamond = buf.readBoolean();
            this.stonemasonStone = buf.readBoolean();
            this.stonemasonSand = buf.readBoolean();
            this.stonemasonNetherrack = buf.readBoolean();
            this.stonemasonQuartz = buf.readBoolean();
            this.guardArmor = buf.readBoolean();
            this.guardWeapon = buf.readBoolean();
            this.citizenVisit = buf.readBoolean();
        }
    }
}

