/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.jobs;

import com.minecolonies.client.render.RenderBipedCitizen;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.jobs.JobBuilder;
import com.minecolonies.colony.jobs.JobDeliveryman;
import com.minecolonies.colony.jobs.JobFarmer;
import com.minecolonies.colony.jobs.JobFisherman;
import com.minecolonies.colony.jobs.JobLumberjack;
import com.minecolonies.colony.jobs.JobMiner;
import com.minecolonies.colony.jobs.JobPlaceholder;
import com.minecolonies.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJob {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ITEMS_NEEDED = "itemsNeeded";
    private static final String MAPPING_PLACEHOLDER = "Placeholder";
    private static final String MAPPING_BUILDER = "Builder";
    private static final String MAPPING_DELIVERY = "Deliveryman";
    private static final String MAPPING_MINER = "Miner";
    private static final String MAPPING_LUMBERJACK = "Lumberjack";
    private static final String MAPPING_FARMER = "Farmer";
    private static final String MAPPING_FISHERMAN = "Fisherman";
    private static final int TASK_PRIORITY = 3;
    @NotNull
    private static Map<String, Class<? extends AbstractJob>> nameToClassMap = new HashMap<String, Class<? extends AbstractJob>>();
    @NotNull
    private static Map<Class<? extends AbstractJob>, String> classToNameMap = new HashMap<Class<? extends AbstractJob>, String>();
    private final CitizenData citizen;
    @NotNull
    private List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    private String nameTag = "";

    public AbstractJob(CitizenData entity) {
        this.citizen = entity;
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractJob> jobClass) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Job class mapping");
        }
        try {
            if (jobClass.getDeclaredConstructor(CitizenData.class) != null) {
                nameToClassMap.put(name, jobClass);
                classToNameMap.put(jobClass, name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Job class mapping", exception);
        }
    }

    @Nullable
    public static AbstractJob createFromNBT(CitizenData citizen, @NotNull NBTTagCompound compound) {
        AbstractJob job = null;
        Class<? extends AbstractJob> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.func_74779_i(TAG_TYPE));
            if (oclass != null) {
                Constructor<? extends AbstractJob> constructor = oclass.getDeclaredConstructor(CitizenData.class);
                job = constructor.newInstance(citizen);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.logger.trace((Object)e);
        }
        if (job != null) {
            try {
                job.readFromNBT(compound);
            }
            catch (RuntimeException ex) {
                Log.logger.error(String.format("A Job %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
                job = null;
            }
        } else {
            Log.logger.warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
        }
        return job;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList itemsNeededTag = compound.func_150295_c(TAG_ITEMS_NEEDED, 10);
        for (int i = 0; i < itemsNeededTag.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = itemsNeededTag.func_150305_b(i);
            this.itemsNeeded.add(ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
    }

    public abstract String getName();

    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.CITIZEN;
    }

    public CitizenData getCitizen() {
        return this.citizen;
    }

    public Colony getColony() {
        return this.citizen.getColony();
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a(TAG_TYPE, s);
        if (!this.itemsNeeded.isEmpty()) {
            NBTTagList itemsNeededTag = new NBTTagList();
            for (ItemStack itemstack : this.itemsNeeded) {
                NBTTagCompound itemCompound = new NBTTagCompound();
                itemstack.func_77955_b(itemCompound);
                itemsNeededTag.func_74742_a((NBTBase)itemCompound);
            }
            compound.func_74782_a(TAG_ITEMS_NEEDED, (NBTBase)itemsNeededTag);
        }
    }

    public boolean isMissingNeededItem() {
        return !this.itemsNeeded.isEmpty();
    }

    @NotNull
    public List<ItemStack> getItemsNeeded() {
        return Collections.unmodifiableList(this.itemsNeeded);
    }

    public void clearItemsNeeded() {
        this.itemsNeeded.clear();
    }

    public void addItemNeeded(@NotNull ItemStack stack) {
        for (ItemStack neededItem : this.itemsNeeded) {
            if ((!stack.func_77973_b().func_77645_m() || stack.func_77973_b() != neededItem.func_77973_b()) && !stack.func_77969_a(neededItem)) continue;
            neededItem.field_77994_a += stack.field_77994_a;
            return;
        }
        this.itemsNeeded.add(stack);
    }

    @Nullable
    public ItemStack removeItemNeeded(@NotNull ItemStack stack) {
        ItemStack stackCopy = stack.func_77946_l();
        for (ItemStack neededItem : this.itemsNeeded) {
            if ((!stack.func_77973_b().func_77645_m() || stack.func_77973_b() != neededItem.func_77973_b()) && !stack.func_77969_a(neededItem)) continue;
            int itemsToRemove = Math.min(neededItem.field_77994_a, stackCopy.field_77994_a);
            neededItem.field_77994_a -= itemsToRemove;
            stackCopy.field_77994_a -= itemsToRemove;
            if (neededItem.field_77994_a != 0) break;
            this.itemsNeeded.remove(neededItem);
            break;
        }
        return stackCopy.field_77994_a == 0 ? null : stackCopy;
    }

    public void addTasks(@NotNull EntityAITasks tasks) {
        AbstractAISkeleton aiTask = this.generateAI();
        if (aiTask != null) {
            tasks.func_75776_a(3, (EntityAIBase)aiTask);
        }
    }

    public abstract AbstractAISkeleton generateAI();

    public String getNameTagDescription() {
        return this.nameTag;
    }

    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    static {
        AbstractJob.addMapping(MAPPING_PLACEHOLDER, JobPlaceholder.class);
        AbstractJob.addMapping(MAPPING_BUILDER, JobBuilder.class);
        AbstractJob.addMapping(MAPPING_DELIVERY, JobDeliveryman.class);
        AbstractJob.addMapping(MAPPING_MINER, JobMiner.class);
        AbstractJob.addMapping(MAPPING_LUMBERJACK, JobLumberjack.class);
        AbstractJob.addMapping(MAPPING_FARMER, JobFarmer.class);
        AbstractJob.addMapping(MAPPING_FISHERMAN, JobFisherman.class);
    }
}

