/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity;

import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.util.MathUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityFishHook
extends Entity {
    private static final int TTL = 360;
    private static final List junkDrops = Arrays.asList(new WeightedRandomFishable(new ItemStack((Item)Items.field_151021_T), 10).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.field_151116_aA), 10), new WeightedRandomFishable(new ItemStack(Items.field_151103_aS), 10), new WeightedRandomFishable(new ItemStack((Item)Items.field_151068_bn), 10), new WeightedRandomFishable(new ItemStack(Items.field_151007_F), 5), new WeightedRandomFishable(new ItemStack((Item)Items.field_151112_aM), 2).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.field_151054_z), 10), new WeightedRandomFishable(new ItemStack(Items.field_151055_y), 5), new WeightedRandomFishable(new ItemStack(Items.field_151100_aR, 10, 0), 1), new WeightedRandomFishable(new ItemStack((Block)Blocks.field_150479_bC), 10), new WeightedRandomFishable(new ItemStack(Items.field_151078_bh), 10));
    private static final float ENTITY_SIZE = 0.25f;
    private static final List rareDrops = Arrays.asList(new WeightedRandomFishable(new ItemStack(Blocks.field_150392_bi), 1), new WeightedRandomFishable(new ItemStack(Items.field_151057_cb), 1), new WeightedRandomFishable(new ItemStack(Items.field_151141_av), 1), new WeightedRandomFishable(new ItemStack((Item)Items.field_151031_f), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack((Item)Items.field_151112_aM), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack(Items.field_151122_aG), 1).func_150707_a());
    private static final List fishDrops = Arrays.asList(new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));
    private static final double HALF_CIRCLE = 180.0;
    private static final double RANDOM_MOVEMENT_OFFSET = (double)0.0075f;
    private static final double INITIAL_MOVEMENT_LIMITER = 0.16;
    private static final double SUNKEN_OFFSET = (double)0.1f;
    private static final double NUM_BOUNDING_BOX_EDGES = 4.0;
    private static final double DISTANCE_FACTOR = 64.0;
    private static final double BOUNCE_MOVEMENT_LIMITER = 0.2;
    private static final float AIR_MOVEMENT_LIMITER = 0.92f;
    private static final double GROUND_MOVEMENT_LIMITER = 0.5;
    private static final double WATER_MOVEMENT_LIMITER = (double)0.04f;
    private static final double NO_CLEAR_SKY_CHANCE = 0.5;
    private static final double INCREASE_RARENESS_MODIFIER = 7.5;
    private EntityCitizen citizen;
    private int fishingSpeedEnchantment;
    private int fishingLootEnchantment;
    private boolean inGround;
    private int shake;
    private int countdownNoFish;
    private int countdownFishNear;
    private int countdownFishBites;
    private double relativeRotation;
    private long creationTime;
    private boolean isFishCaugth = false;

    public EntityFishHook(World world, @NotNull EntityCitizen citizen) {
        this(world);
        this.citizen = citizen;
        this.func_70012_b(citizen.field_70165_t, citizen.field_70163_u + 1.62 - citizen.func_70033_W(), citizen.field_70161_v, citizen.field_70177_z, citizen.field_70125_A);
        this.field_70165_t -= Math.cos((double)this.field_70177_z / 180.0 * Math.PI) * 0.16;
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= Math.sin((double)this.field_70177_z / 180.0 * Math.PI) * 0.16;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        double f = 0.4;
        this.field_70159_w = -Math.sin((double)this.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.field_70125_A / 180.0 * Math.PI) * f;
        this.field_70179_y = Math.cos((double)this.field_70177_z / 180.0 * Math.PI) * Math.cos((double)this.field_70125_A / 180.0 * Math.PI) * f;
        this.field_70181_x = -Math.sin((double)this.field_70125_A / 180.0 * Math.PI) * f;
        this.setPosition(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5, 1.0);
        this.fishingSpeedEnchantment = EnchantmentHelper.func_151387_h((EntityLivingBase)citizen);
        this.fishingLootEnchantment = EnchantmentHelper.func_151386_g((EntityLivingBase)citizen);
    }

    public EntityFishHook(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.creationTime = System.nanoTime();
        this.fishingLootEnchantment = 0;
        this.fishingSpeedEnchantment = 0;
    }

    private void setPosition(double x, double y, double z, double yaw, double pitch) {
        double squareRootXYZ = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        double newX = x / squareRootXYZ;
        double newY = y / squareRootXYZ;
        double newZ = z / squareRootXYZ;
        newX += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        newY += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        newZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * pitch;
        this.field_70159_w = newX *= yaw;
        this.field_70181_x = newY *= yaw;
        this.field_70179_y = newZ *= yaw;
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(newX, newZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(newY, Math.sqrt(newX * newX + newZ * newZ)) * 180.0 / Math.PI);
    }

    public EntityCitizen getCitizen() {
        return this.citizen;
    }

    protected void func_70088_a() {
    }

    public boolean equals(@Nullable Object o) {
        return o != null && ((Object)((Object)this)).getClass() == o.getClass() && super.equals(o);
    }

    public int hashCode() {
        return this.func_145782_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.fishHookIsOverTimeToLive()) {
            this.func_70106_y();
        }
        if (this.bounceFromGround() || this.inGround) {
            return;
        }
        this.moveSomeStuff();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double range) {
        double maxLength = this.func_174813_aQ().func_72320_b() * 4.0;
        return range < (maxLength *= 64.0) * maxLength;
    }

    public void func_70037_a(NBTTagCompound unused) {
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound unused) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double vectorX, double vectorY, double vectorZ) {
        this.field_70159_w = vectorX;
        this.field_70181_x = vectorY;
        this.field_70179_y = vectorZ;
    }

    public boolean fishHookIsOverTimeToLive() {
        return MathUtils.nanoSecondsToSeconds(System.nanoTime() - this.creationTime) > 360L;
    }

    private boolean bounceFromGround() {
        if (this.shake > 0) {
            --this.shake;
        }
        if (!this.inGround) {
            return false;
        }
        this.inGround = false;
        this.field_70159_w *= this.field_70146_Z.nextDouble() * 0.2;
        this.field_70181_x *= this.field_70146_Z.nextDouble() * 0.2;
        this.field_70179_y *= this.field_70146_Z.nextDouble() * 0.2;
        return false;
    }

    private void moveSomeStuff() {
        this.updateMotionAndRotation();
        double movementLimiter = 0.92f;
        if (this.field_70122_E || this.field_70123_F) {
            movementLimiter = 0.5;
        }
        int numSteps = 5;
        double waterDensity = 0.0;
        for (int j = 0; j < numSteps; ++j) {
            double d3 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)j / (double)numSteps;
            double d4 = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(j + 1) / (double)numSteps;
            AxisAlignedBB axisAlignedBB1 = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, d3, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, d4, this.func_174813_aQ().field_72334_f);
            if (!this.field_70170_p.func_72830_b(axisAlignedBB1, Material.field_151586_h)) continue;
            waterDensity += 1.0 / (double)numSteps;
        }
        this.checkIfFishBites(waterDensity);
        double currentDistance = waterDensity * 2.0 - 1.0;
        this.field_70181_x += (double)0.04f * currentDistance;
        if (waterDensity > 0.0) {
            movementLimiter *= 0.9;
            this.field_70181_x *= 0.8;
        }
        this.field_70159_w *= movementLimiter;
        this.field_70181_x *= movementLimiter;
        this.field_70179_y *= movementLimiter;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void updateMotionAndRotation() {
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = (float)(Math.atan2(this.field_70181_x, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
        while ((double)this.field_70125_A - (double)this.field_70127_C < -180.0) {
            this.field_70127_C = (float)((double)this.field_70127_C - 360.0);
        }
        while ((double)this.field_70125_A - (double)this.field_70127_C >= 180.0) {
            this.field_70127_C = (float)((double)this.field_70127_C + 360.0);
        }
        while ((double)this.field_70177_z - (double)this.field_70126_B < -180.0) {
            this.field_70126_B = (float)((double)this.field_70126_B - 360.0);
        }
        while ((double)this.field_70177_z - (double)this.field_70126_B >= 180.0) {
            this.field_70126_B = (float)((double)this.field_70126_B + 360.0);
        }
        this.field_70125_A = (float)((double)this.field_70127_C + ((double)this.field_70125_A - (double)this.field_70127_C) * 0.2);
        this.field_70177_z = (float)((double)this.field_70126_B + ((double)this.field_70177_z - (double)this.field_70126_B) * 0.2);
    }

    private void checkIfFishBites(double waterDensity) {
        if (!this.field_70170_p.field_72995_K && waterDensity > 0.0) {
            int fishingProgressStep = 1;
            if (this.field_70146_Z.nextDouble() < 0.5 && !this.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) + 1, MathHelper.func_76128_c((double)this.field_70161_v)))) {
                --fishingProgressStep;
            }
            if (this.countdownNoFish > 0) {
                this.updateNoFishCounter();
                return;
            }
            WorldServer worldServer = (WorldServer)this.field_70170_p;
            if (this.countdownFishNear > 0) {
                this.renderBubble(fishingProgressStep, worldServer);
                return;
            }
            if (this.countdownFishBites > 0) {
                this.countdownFishBites -= fishingProgressStep;
                this.renderFishBiteOrSwim(worldServer);
            } else {
                this.countdownFishNear = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)900);
                this.countdownFishNear -= this.fishingSpeedEnchantment * 20 * 5;
            }
        }
    }

    private void updateNoFishCounter() {
        --this.countdownNoFish;
        if (this.countdownNoFish <= 0) {
            this.countdownFishNear = 0;
            this.countdownFishBites = 0;
        } else {
            this.field_70181_x -= this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() * 0.2;
        }
    }

    private void renderBubble(int fishingProgressStep, @NotNull WorldServer worldServer) {
        this.countdownFishNear -= fishingProgressStep;
        double bubbleY = 0.15;
        if (this.countdownFishNear < 20) {
            bubbleY += (double)(20 - this.countdownFishNear) * 0.05;
        } else if (this.countdownFishNear < 40) {
            bubbleY += (double)(40 - this.countdownFishNear) * 0.02;
        } else if (this.countdownFishNear < 60) {
            bubbleY += (double)(60 - this.countdownFishNear) * 0.01;
        }
        if (this.field_70146_Z.nextDouble() < bubbleY) {
            this.renderLittleSplash(worldServer);
        }
        if (this.countdownFishNear <= 0) {
            this.relativeRotation = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
            this.countdownFishBites = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
        }
    }

    private void renderFishBiteOrSwim(@NotNull WorldServer worldServer) {
        if (this.countdownFishBites <= 0) {
            this.showFishBiteAnimation(worldServer);
        } else {
            this.showFishSwimmingTowardsHookAnimation(worldServer);
        }
    }

    private void renderLittleSplash(@NotNull WorldServer worldServer) {
        double sinYPosition = (double)MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * 0.017453292;
        double cosYPosition = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
        double bubbleX = this.field_70165_t + Math.sin(sinYPosition) * cosYPosition * 0.1;
        double increasedYPosition = Math.floor(this.func_174813_aQ().field_72338_b) + 1.0;
        double bubbleZ = this.field_70161_v + Math.cos(sinYPosition) * cosYPosition * 0.1;
        worldServer.func_175739_a(EnumParticleTypes.WATER_SPLASH, bubbleX, increasedYPosition, bubbleZ, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
    }

    private void showFishBiteAnimation(@NotNull WorldServer worldServer) {
        this.field_70181_x -= (double)0.2f;
        this.func_85030_a("random.splash", 0.25f, (float)(1.0 + this.field_70146_Z.nextGaussian() * 0.4));
        double bubbleY = Math.floor(this.func_174813_aQ().field_72338_b);
        worldServer.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, bubbleY + 1.0, this.field_70161_v, (int)(1.0 + (double)this.field_70130_N * 20.0), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, bubbleY + 1.0, this.field_70161_v, (int)(1.0 + (double)this.field_70130_N * 20.0), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
        this.countdownNoFish = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)10, (int)30);
        this.isFishCaugth = true;
    }

    private void showFishSwimmingTowardsHookAnimation(@NotNull WorldServer worldServer) {
        this.relativeRotation += this.field_70146_Z.nextGaussian() * 4.0;
        double bubbleY = this.relativeRotation * 0.017453292;
        double sinYPosition = Math.sin(bubbleY);
        double cosYPosition = Math.cos(bubbleY);
        double bubbleX = this.field_70165_t + sinYPosition * (double)this.countdownFishBites * 0.1;
        double increasedYPosition = Math.floor(this.func_174813_aQ().field_72338_b) + 1.0;
        double bubbleZ = this.field_70161_v + cosYPosition * (double)this.countdownFishBites * 0.1;
        if (this.field_70146_Z.nextDouble() < 0.15) {
            worldServer.func_175739_a(EnumParticleTypes.WATER_BUBBLE, bubbleX, increasedYPosition - (double)0.1f, bubbleZ, 1, sinYPosition, 0.1, cosYPosition, 0.0, new int[0]);
        }
        double f3 = sinYPosition * 0.04;
        double f4 = cosYPosition * 0.04;
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, f4, 0.01, -f3, 1.0, new int[0]);
        worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, bubbleX, increasedYPosition, bubbleZ, 0, -f4, 0.01, f3, 1.0, new int[0]);
    }

    public int getDamage(@NotNull EntityCitizen citizen) {
        if (this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return 0;
        }
        int itemDamage = 0;
        if (this.isFishCaugth) {
            if (this.countdownNoFish > 0) {
                this.spawnLootAndExp(citizen);
                itemDamage = 1;
            }
            if (this.inGround) {
                itemDamage = 0;
            }
        }
        this.func_70106_y();
        return itemDamage;
    }

    private void spawnLootAndExp(@NotNull EntityCitizen citizen) {
        double citizenPosX = citizen.field_70165_t;
        double citizenPosY = citizen.field_70163_u;
        double citizenPosZ = citizen.field_70161_v;
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFishingLoot(citizen));
        double distanceX = citizenPosX - this.field_70165_t;
        double distanceY = citizenPosY - this.field_70163_u;
        double distanceZ = citizenPosZ - this.field_70161_v;
        entityitem.field_70159_w = distanceX * 0.1;
        entityitem.field_70181_x = distanceY * 0.1 + Math.sqrt(Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ)) * 0.08;
        entityitem.field_70179_y = distanceZ * 0.1;
        this.field_70170_p.func_72838_d((Entity)entityitem);
        citizen.field_70170_p.func_72838_d((Entity)new EntityXPOrb(citizen.field_70170_p, citizenPosX, citizenPosY + 0.0, citizenPosZ + 0.5, this.field_70146_Z.nextInt(6) + 1));
    }

    private ItemStack getFishingLoot(@NotNull EntityCitizen citizen) {
        double random = this.field_70170_p.field_73012_v.nextDouble() / 7.5;
        double speedBonus = 0.1 - (double)this.fishingSpeedEnchantment * 0.025 - (double)this.fishingLootEnchantment * 0.01;
        double lootBonus = 0.05 + (double)this.fishingSpeedEnchantment * 0.01 - (double)this.fishingLootEnchantment * 0.01;
        speedBonus = MathHelper.func_76131_a((float)((float)speedBonus), (float)0.0f, (float)1.0f);
        lootBonus = MathHelper.func_76131_a((float)((float)lootBonus), (float)0.0f, (float)1.0f);
        int buildingLevel = citizen.getWorkBuilding().getBuildingLevel();
        if (random < speedBonus || buildingLevel == 1) {
            return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)this.field_70146_Z, (Collection)fishDrops)).func_150708_a(this.field_70146_Z);
        }
        if ((random -= speedBonus) < lootBonus || buildingLevel == 2) {
            return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)this.field_70146_Z, (Collection)junkDrops)).func_150708_a(this.field_70146_Z);
        }
        return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)this.field_70146_Z, (Collection)rareDrops)).func_150708_a(this.field_70146_Z);
    }

    public boolean caughtFish() {
        return this.isFishCaugth;
    }
}

