/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.pathfinding.AbstractPathJob;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.util.Log;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    private static final double TIE_BREAKER = 1.001;
    @NotNull
    protected final BlockPos avoid;
    @NotNull
    protected final BlockPos heuristicPoint;
    protected final int avoidDistance;

    public PathJobMoveAwayFromLocation(World world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range) {
        super(world, start, avoid, range);
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        double dx = start.func_177958_n() - avoid.func_177958_n();
        double dz = start.func_177952_p() - avoid.func_177952_p();
        double scalar = (double)avoidDistance / Math.sqrt(dx * dx + dz * dz);
        this.heuristicPoint = new BlockPos(start.func_177958_n() + (int)(dx *= scalar), start.func_177956_o(), start.func_177952_p() + (int)(dz *= scalar));
    }

    @Override
    @Nullable
    protected PathEntity search() {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.logger.info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.avoid.func_177958_n(), this.avoid.func_177956_o(), this.avoid.func_177952_p()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.heuristicPoint.func_177958_n();
        int dy = pos.func_177956_o() - this.heuristicPoint.func_177956_o();
        int dz = pos.func_177952_p() - this.heuristicPoint.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return this.getNodeResultScore(n) >= (double)(this.avoidDistance * this.avoidDistance);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.avoid.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p());
    }
}

