/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryField
implements IInventory {
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_CUSTOM_NAME = "name";
    private static final String TAG_INVENTORY = "inventory";
    private static final int NO_SLOT = -1;
    @NotNull
    private ItemStack[] stackResult = new ItemStack[1];
    private String customName = "";
    private boolean inventoryChanged = false;

    public InventoryField(String title) {
        this.customName = title;
    }

    public boolean hasInventoryChanged() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c(TAG_ITEMS, 10);
        this.stackResult = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c(TAG_SLOT) & 0x7F;
            if (j == -1 || j >= this.stackResult.length) continue;
            this.stackResult[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        if (compound.func_150297_b(TAG_CUSTOM_NAME, 8)) {
            this.customName = compound.func_74779_i(TAG_CUSTOM_NAME);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        return this.stackResult[0];
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        if (this.stackResult[index] == null) {
            return null;
        }
        if (this.stackResult[index].field_77994_a <= count) {
            ItemStack itemStack1 = this.stackResult[index];
            this.stackResult[index] = null;
            this.func_70296_d();
            return itemStack1;
        }
        ItemStack itemstack = this.stackResult[index].func_77979_a(count);
        if (this.stackResult[index].field_77994_a == 0) {
            this.stackResult[index] = null;
        }
        this.func_70296_d();
        return itemstack;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        if (this.stackResult[index] == null) {
            return null;
        }
        ItemStack itemstack = this.stackResult[index];
        this.stackResult[index] = null;
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.stackResult[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.inventoryChanged = true;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    public boolean func_94041_b(int index, @Nullable ItemStack itemStack) {
        return index == 0 && itemStack != null && itemStack.func_77973_b() instanceof ItemSeeds;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stackResult.length; ++i) {
            this.stackResult[i] = null;
        }
    }

    @NotNull
    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stackResult.length; ++i) {
            if (this.stackResult[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a(TAG_SLOT, (byte)i);
            this.stackResult[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a(TAG_ITEMS, (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a(TAG_CUSTOM_NAME, this.customName);
        }
        compound.func_74782_a(TAG_INVENTORY, (NBTBase)nbttaglist);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @NotNull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "field.inventory";
    }
}

