/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveBuildingMessage
implements IMessage,
IMessageHandler<ColonyViewRemoveBuildingMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;

    public ColonyViewRemoveBuildingMessage() {
    }

    public ColonyViewRemoveBuildingMessage(@NotNull Colony colony, BlockPos building) {
        this.colonyId = colony.getID();
        this.buildingId = building;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewRemoveBuildingMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewRemoveBuildingMessage(message.colonyId, message.buildingId);
    }
}

