/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.colony.permissions.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerUtils {
    private ServerUtils() {
    }

    @Nullable
    public static EntityPlayer getPlayerFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            if (!id.equals(((EntityPlayer)world.field_73010_i.get(i)).func_146103_bH().getId())) continue;
            return (EntityPlayer)world.field_73010_i.get(i);
        }
        return null;
    }

    @NotNull
    public static List<EntityPlayer> getPlayersFromUUID(@NotNull World world, @NotNull Collection<UUID> ids) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Object o : world.field_73010_i) {
            EntityPlayer player;
            if (!(o instanceof EntityPlayer) || !ids.contains((player = (EntityPlayer)o).func_146103_bH().getId())) continue;
            players.add(player);
            if (players.size() != ids.size()) continue;
            return players;
        }
        return players;
    }

    @NotNull
    public static List<EntityPlayer> getPlayersFromPermPlayer(@NotNull List<Permissions.Player> players) {
        ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
        for (Permissions.Player player : players) {
            playerList.add(ServerUtils.getPlayerFromPermPlayer(player));
        }
        return playerList;
    }

    @Nullable
    public static EntityPlayer getPlayerFromPermPlayer(@NotNull Permissions.Player player) {
        return ServerUtils.getPlayerFromUUID(player.getID());
    }

    @Nullable
    public static EntityPlayer getPlayerFromUUID(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        List allPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : allPlayers) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }
}

