/*
 * Decompiled with CFR 0.152.
 */
package com.schematica;

import com.minecolonies.util.BlockPosUtil;
import com.schematica.client.renderer.RenderSchematic;
import com.schematica.client.world.SchematicWorld;
import com.schematica.world.storage.Schematic;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    private boolean inHutMode = true;
    @Nullable
    private SchematicWorld schematic = null;
    private int rotation = 0;
    private String hutDec = "";
    private String style = "";
    private int level = 0;
    private boolean isPendingReset = false;

    private Settings() {
    }

    public void moveTo(BlockPos pos) {
        if (this.schematic == null) {
            return;
        }
        BlockPosUtil.set(this.offset, pos.func_177973_b((Vec3i)this.schematic.getSchematic().getOffset()));
        BlockPosUtil.set(this.schematic.position, (BlockPos)this.offset);
    }

    @Nullable
    public Schematic getActiveSchematic() {
        return this.schematic == null ? null : this.schematic.getSchematic();
    }

    public void setActiveSchematic(Schematic schematic) {
        if (schematic != null) {
            this.schematic = new SchematicWorld(schematic);
            RenderSchematic.INSTANCE.setWorldAndLoadRenderers(this.schematic);
            this.schematic.isRendering = true;
        } else {
            this.reset();
        }
    }

    public void reset() {
        this.schematic = null;
        RenderSchematic.INSTANCE.setWorldAndLoadRenderers(null);
        this.isPendingReset = false;
    }

    public SchematicWorld getSchematicWorld() {
        return this.schematic;
    }

    public boolean isInHutMode() {
        return this.inHutMode;
    }

    public void setInHutMode(boolean mode) {
        this.inHutMode = mode;
    }

    public void setSchematicInfo(String hutDec, String style, int level, int rotation) {
        this.hutDec = hutDec;
        this.style = style;
        this.level = level;
        this.rotation = rotation;
    }

    public String getHutDec() {
        return this.hutDec;
    }

    public String getStyle() {
        return this.style;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void markDirty() {
        this.isPendingReset = true;
    }

    public boolean isDirty() {
        return this.isPendingReset;
    }

    @NotNull
    public BlockPos getOffset() {
        return this.offset.getImmutable();
    }
}

