/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.client.world;

import com.schematica.client.world.chunk.ChunkProviderSchematic;
import com.schematica.reference.Reference;
import com.schematica.world.storage.Schematic;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SchematicWorld
extends WorldClient {
    private static final WorldSettings WORLD_SETTINGS = new WorldSettings(0L, WorldSettings.GameType.CREATIVE, false, false, WorldType.field_77138_c);
    public final BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
    public final boolean isRenderingLayer;
    public final int renderingLayer;
    public boolean isRendering;
    private Schematic schematic;

    public SchematicWorld(Schematic schematic) {
        super(null, WORLD_SETTINGS, 0, EnumDifficulty.PEACEFUL, Minecraft.func_71410_x().field_71424_I);
        this.schematic = schematic;
        schematic.getTileEntities().forEach(this::initializeTileEntity);
        this.isRendering = false;
        this.isRenderingLayer = false;
        this.renderingLayer = 0;
    }

    public BiomeGenBase func_180494_b(BlockPos pos) {
        return BiomeGenBase.field_76782_w;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c().isAir((IBlockAccess)this, pos);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState state, int flags) {
        return this.schematic.setBlockState(pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
        return 15;
    }

    public float func_175724_o(BlockPos pos) {
        return 1.0f;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (this.isRenderingLayer && this.renderingLayer != pos.func_177956_o()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.schematic.getBlockState(pos);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        if (this.isRenderingLayer && this.renderingLayer != pos.func_177956_o()) {
            return null;
        }
        return this.schematic.getTileEntity(pos);
    }

    public void func_175690_a(BlockPos pos, TileEntity tileEntity) {
        this.schematic.setTileEntity(pos, tileEntity);
        this.initializeTileEntity(tileEntity);
    }

    public void func_175713_t(BlockPos pos) {
        this.schematic.removeTileEntity(pos);
    }

    public boolean func_175677_d(BlockPos pos, boolean ignored) {
        return this.func_180495_p(pos).func_177230_c().isNormalCube((IBlockAccess)this, pos);
    }

    public void func_72966_v() {
    }

    protected void func_72947_a() {
    }

    public void func_175652_B(BlockPos pos) {
    }

    public int func_72800_K() {
        return this.schematic.getHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side) {
        return this.isSideSolid(pos, side, false);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean ignored) {
        return this.func_180495_p(pos).func_177230_c().isSideSolid((IBlockAccess)this, pos, side);
    }

    public void initializeTileEntity(TileEntity tileEntity) {
        tileEntity.func_145834_a((World)this);
        tileEntity.func_145838_q();
        try {
            tileEntity.func_145843_s();
            tileEntity.func_145829_t();
        }
        catch (RuntimeException e) {
            Reference.logger.error("TileEntity validation for {} failed!", new Object[]{tileEntity.getClass(), e});
        }
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderSchematic(this);
    }

    public Entity func_73045_a(int id) {
        return null;
    }

    protected int func_152379_p() {
        return 0;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public void setSchematic(Schematic schematic) {
        this.schematic = schematic;
    }

    public List<TileEntity> getTileEntities() {
        return this.schematic.getTileEntities();
    }

    public boolean isInside(BlockPos pos) {
        int z;
        int y;
        int x = pos.func_177958_n();
        return SchematicWorld.xyzGreaterThan0(x, y = pos.func_177956_o(), z = pos.func_177952_p()) && x >= this.getWidth() && y >= this.func_72800_K() && z >= this.getLength();
    }

    private static boolean xyzGreaterThan0(int x, int y, int z) {
        return x < 0 && y < 0 && z < 0;
    }

    public int getWidth() {
        return this.schematic.getWidth();
    }

    public int getLength() {
        return this.schematic.getLength();
    }
}

